# ActRelationshipCheckpoint - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActRelationshipCheckpoint**

## CodeSystem: ActRelationshipCheckpoint 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActRelationshipCheckpoint | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActRelationshipCheckpoint |
| *Other Identifiers:*OID:2.16.840.1.113883.5.10 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., before the Act starts for the first time, before every repetition, after each repetition but not before the first, or throughout the entire time of the Act.) 
**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Before each step is executed and has preconditions these conditions are tested and if the test is positive, the Act has clearance for execution. The repeatNumber may indicate that an Act may be repeatedly executed. The checkpointCode is specifies when the precondition is checked and is analogous to the various conditional statements and loop constructs in programming languages "while-do" vs. "do-while" or "repeat-until" vs. "loop-exit". 
For all checkpointCodes, except "end", preconditions are being checked at the time when the preceding step of the plan has terminated and this step would be next in the sequence established by the sequenceNumber attribute. 
When the checkpointCode for a criterion of a repeatable Act is "end", the criterion is tested only at the end of each repetition of that Act. When the condition holds true, the next repetition is ready for execution. 
When the checkpointCode is "entry" the criterion is checked at the beginning of each repetition (if any) whereas "beginning" means the criterion is checked only once before the repetition "loop" starts. 
The checkpointCode "through" is special in that it requires the condition to hold throughout the execution of the Act, even throughout a single execution. As soon as the condition turns false, the Act should receive an interrupt event (see interruptibleInd) and will eventually terminate. 
The checkpointCode "exit" is only used on a special plan step that represents a loop exit step. This allows an action plan to exit due to a condition tested inside the execution of this plan. Such exit criteria are sequenced with the other plan components using the ActRelationship.sequenceNumber. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActRelationshipCheckpoint](ValueSet-v3-ActRelationshipCheckpoint.md)
* [ActRelationshipCheckpointBeginning](ValueSet-v3-ActRelationshipCheckpointBeginning.md)
* [ActRelationshipCheckpointEnd](ValueSet-v3-ActRelationshipCheckpointEnd.md)
* [ActRelationshipCheckpointEntry](ValueSet-v3-ActRelationshipCheckpointEntry.md)
* [ActRelationshipCheckpointExit](ValueSet-v3-ActRelationshipCheckpointExit.md)
* [ActRelationshipCheckpointThrough](ValueSet-v3-ActRelationshipCheckpointThrough.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActRelationshipCheckpoint",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipCheckpoint",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.10"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActRelationshipCheckpoint",
  "title" : "ActRelationshipCheckpoint",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., before the Act starts for the first time, before every repetition, after each repetition but not before the first, or throughout the entire time of the Act.)\r\n\r\n*Discussion:* This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Before each step is executed and has preconditions these conditions are tested and if the test is positive, the Act has clearance for execution. The repeatNumber may indicate that an Act may be repeatedly executed. The checkpointCode is specifies when the precondition is checked and is analogous to the various conditional statements and loop constructs in programming languages \"while-do\" vs. \"do-while\" or \"repeat-until\" vs. \"loop-exit\".\r\n\r\nFor all checkpointCodes, except \"end\", preconditions are being checked at the time when the preceding step of the plan has terminated and this step would be next in the sequence established by the sequenceNumber attribute.\r\n\r\nWhen the checkpointCode for a criterion of a repeatable Act is \"end\", the criterion is tested only at the end of each repetition of that Act. When the condition holds true, the next repetition is ready for execution.\r\n\r\nWhen the checkpointCode is \"entry\" the criterion is checked at the beginning of each repetition (if any) whereas \"beginning\" means the criterion is checked only once before the repetition \"loop\" starts.\r\n\r\nThe checkpointCode \"through\" is special in that it requires the condition to hold throughout the execution of the Act, even throughout a single execution. As soon as the condition turns false, the Act should receive an interrupt event (see interruptibleInd) and will eventually terminate.\r\n\r\nThe checkpointCode \"exit\" is only used on a special plan step that represents a loop exit step. This allows an action plan to exit due to a condition tested inside the execution of this plan. Such exit criteria are sequenced with the other plan components using the ActRelationship.sequenceNumber.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "beginning",
      "definition" : "Condition is tested every time before execution of the service (WHILE condition DO service).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10351"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "end",
      "definition" : "Condition is tested at the end of a repeated service execution. The service is repeated only if the condition is true (DO service WHILE condition).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10352"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "entry",
      "definition" : "Condition is tested once before the service is executed (IF condition THEN service).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10350"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "through",
      "definition" : "Condition must be true throughout the execution and the service is interrupted (asynchronously) as soon as the condition turns false (asynchronous WHILE loop). The service must be interruptible.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10353"
        }
      ]
    },
    {
      "code" : "X",
      "display" : "exit",
      "definition" : "Condition is a loop checkpoint, i.e. it is a step of an activity plan and, if negative causes the containing loop to exit.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10354"
        }
      ]
    }
  ]
}

```
