# orderStatusModifier - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **orderStatusModifier**

## CodeSystem: orderStatusModifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0950 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrderStatusModifier |
| *Other Identifiers:*OID:2.16.840.1.113883.18.450 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to further define the status identified in ORC-5. Used in HL7 Version 2 messaging in the ORC segment. 

 
Underlying Master Code System for V2 table 0950 (Order Status Modifier) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOrderStatusModifier](ValueSet-v2-0950.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0950",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0950",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.450"
    }
  ],
  "version" : "2.0.0",
  "name" : "OrderStatusModifier",
  "title" : "orderStatusModifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to further define the status identified in ORC-5.  Used in HL7 Version 2 messaging in the ORC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0950 (Order Status Modifier)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0950",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6773",
      "code" : "EOE",
      "display" : "Expiration on event",
      "definition" : "The order status auto-expires when a specified event occurs",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "6774",
      "code" : "EOT",
      "display" : "Expiration on time",
      "definition" : "The order status is timed and will auto-expire once the prescribed  time interval has passed",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "For example this code would be used to indicate that the order is not currently being worked on but has been placed on a time limited hold awaiting a replacement order. If the hold time expires, default processing will resume."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Filler Applications:\nIn an order replacement setting, sent in recommendation for order replacement message (OML), where ORC-5 = HD, indicating that the hold for a response to the recommendation is timed."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
