# auto-DilutionType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **auto-DilutionType**

## CodeSystem: auto-DilutionType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0945 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AutoDilutionType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.445 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration. Used in Version 2 messaging in the TCD segment. 

 
Underlying Master Code System for V2 table 0945 (Auto-Dilution Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAutoDilutionType](ValueSet-v2-0945.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0945",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0945",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.445"
    }
  ],
  "version" : "2.0.0",
  "name" : "AutoDilutionType",
  "title" : "auto-DilutionType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration.  Used in Version 2 messaging in the TCD segment.",
  "purpose" : "Underlying Master Code System for V2 table 0945 (Auto-Dilution Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0945",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6754",
      "code" : "X2",
      "display" : "Dilution factor 2",
      "definition" : "Specimen pre-diluted by factor 2 applied on the instrument",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "corresponds to ^1^:^2 in TCD-2"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6755",
      "code" : "X5",
      "display" : "Dilution factor 5",
      "definition" : "Specimen pre-diluted by factor 5 applied on the instrument",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "corresponds to ^1^:^5 in TCD-2"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6756",
      "code" : "D1",
      "display" : "Dilution factor 1.23",
      "definition" : "Specimen pre-diluted by factor 1.23 applied on the instrument",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "corresponds to ^1^:^1.23 in TCD-2"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6757",
      "code" : "D2",
      "display" : "Dilution factor 1.45",
      "definition" : "Specimen pre-diluted by factor 1.45 applied on the instrument",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "corresponds to ^1^:^1.45 in TCD-2"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
