# drgDiagnosisDeterminationStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **drgDiagnosisDeterminationStatus**

## CodeSystem: drgDiagnosisDeterminationStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0731 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DrgDiagnosisDeterminationStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.392 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DG1 segment. 

 
Underlying Master Code System for V2 table 0731 (DRG Diagnosis Determination Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDrgDiagnosisDeterminationStatus](ValueSet-v2-0731.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0731",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0731",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.392"
    }
  ],
  "version" : "2.0.0",
  "name" : "DrgDiagnosisDeterminationStatus",
  "title" : "drgDiagnosisDeterminationStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related group (DRG) determination.  US Realm. Used in HL7 Version 2.x messaging in the DG1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0731 (DRG Diagnosis Determination Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0731",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6425",
      "code" : "0",
      "display" : "Valid code",
      "definition" : "Valid code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6426",
      "code" : "1",
      "display" : "Invalid code",
      "definition" : "Invalid code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6427",
      "code" : "2",
      "display" : "Two primary diagnosis codes",
      "definition" : "Two primary diagnosis codes",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6428",
      "code" : "3",
      "display" : "Invalid for this gender",
      "definition" : "Invalid for this gender",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6429",
      "code" : "4",
      "display" : "Invalid for this age",
      "definition" : "Invalid for this age",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
