# dateFormat - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **dateFormat**

## CodeSystem: dateFormat 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0653 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DateFormat |
| *Other Identifiers:*OID:2.16.840.1.113883.18.381 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment. 

 
Underlying Master Code System for V2 table 0653 (Date Format) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDateFormat](ValueSet-v2-0653.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0653",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0653",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.381"
    }
  ],
  "version" : "2.0.0",
  "name" : "DateFormat",
  "title" : "dateFormat",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment.",
  "purpose" : "Underlying Master Code System for V2 table 0653 (Date Format)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0653",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6274",
      "code" : "1",
      "display" : "mm/dd/yy",
      "definition" : "mm/dd/yy",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "USA standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "USA standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6275",
      "code" : "2",
      "display" : "yy.mm.dd",
      "definition" : "yy.mm.dd",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ANSI standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ANSI standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6276",
      "code" : "3",
      "display" : "dd/mm/yy",
      "definition" : "dd/mm/yy",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Britain/France standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Britain/France standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6277",
      "code" : "4",
      "display" : "dd.mm.yy",
      "definition" : "dd.mm.yy",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Germany standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Germany standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6278",
      "code" : "5",
      "display" : "yy/mm/dd",
      "definition" : "yy/mm/dd",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Japan standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Japan standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6279",
      "code" : "6",
      "display" : "Yymmdd",
      "definition" : "Yymmdd",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ISO standard"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ISO standard"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
