# documentCompletionStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **documentCompletionStatus**

## CodeSystem: documentCompletionStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0271 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DocumentCompletionStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.164 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to record the state of a document in a workflow. Used in HL7 Version 2.x messaging in the TXA segment. 

 
Underlying Master Code System for V2 table 0271 (Document Completion Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDocumentCompletionStatus](ValueSet-v2-0271.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0271",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0271",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.164"
    }
  ],
  "version" : "2.0.0",
  "name" : "DocumentCompletionStatus",
  "title" : "documentCompletionStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to record the state of a document in a workflow.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "purpose" : "Underlying Master Code System for V2 table 0271 (Document Completion Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0271",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2645",
      "code" : "DI",
      "display" : "Dictated",
      "definition" : "Dictated",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Diktiert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2646",
      "code" : "DO",
      "display" : "Documented",
      "definition" : "Documented",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dokumentiert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2647",
      "code" : "IP",
      "display" : "In Progress",
      "definition" : "In Progress",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "In Bearbeitung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2648",
      "code" : "IN",
      "display" : "Incomplete",
      "definition" : "Incomplete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Unvollständig"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2649",
      "code" : "PA",
      "display" : "Pre-authenticated",
      "definition" : "Pre-authenticated",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Vorabfreigabe"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2650",
      "code" : "AU",
      "display" : "Authenticated",
      "definition" : "Authenticated",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Freigegeben"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2651",
      "code" : "LA",
      "display" : "Legally authenticated",
      "definition" : "Legally authenticated",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "unterschrieben"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
