# primaryObserverQualification - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **primaryObserverQualification**

## CodeSystem: primaryObserverQualification 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0242 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PrimaryObserverQualification |
| *Other Identifiers:*OID:2.16.840.1.113883.18.141 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation. Used in HL7 Version 2.x messaging in the PEO and PCR segments. 

 
Underlying Master Code System for V2 table 0242 (Primary Observer's Qualification) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPrimaryObserverSQualification](ValueSet-v2-0242.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0242",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0242",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.141"
    }
  ],
  "version" : "2.0.0",
  "name" : "PrimaryObserverQualification",
  "title" : "primaryObserverQualification",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation.  Used in HL7 Version 2.x messaging in the PEO and PCR segments.",
  "purpose" : "Underlying Master Code System for V2 table 0242 (Primary Observer's Qualification)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0242",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2331",
      "code" : "P",
      "display" : "Physician (osteopath, homeopath)",
      "definition" : "Physician (osteopath, homeopath)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2332",
      "code" : "R",
      "display" : "Pharmacist",
      "definition" : "Pharmacist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2333",
      "code" : "M",
      "display" : "Mid-level professional (nurse, nurse practitioner, physician's assistant)",
      "definition" : "Mid-level professional (nurse, nurse practitioner, physician's assistant)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2334",
      "code" : "H",
      "display" : "Other health professional",
      "definition" : "Other health professional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2335",
      "code" : "C",
      "display" : "Health care consumer/patient",
      "definition" : "Health care consumer/patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2336",
      "code" : "L",
      "display" : "Lawyer/attorney",
      "definition" : "Lawyer/attorney",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2337",
      "code" : "O",
      "display" : "Other non-health professional",
      "definition" : "Other non-health professional",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
