# telecommunicationUse - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **telecommunicationUse**

## CodeSystem: telecommunicationUse 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0201 | *Version*:4.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:TelecommunicationUse |
| *Other Identifiers:*OID:2.16.840.1.113883.18.106 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. 

 
Underlying Master Code System for V2 table 0201 (Telecommunication Use Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSTelecommunicationUseCode](ValueSet-v2-0201.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0201",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0201",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.106"
    }
  ],
  "version" : "4.0.0",
  "name" : "TelecommunicationUse",
  "title" : "telecommunicationUse",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts for specifying a specific use of a telecommunication number.  Best practice is to use this concept whenever a telecommunication number or access string is specified.  Used in HL7 Version 2.x messaging in the XTN segment.",
  "purpose" : "Underlying Master Code System for V2 table 0201 (Telecommunication Use Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0201",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "1949",
      "code" : "PRN",
      "display" : "Primary Residence Number",
      "definition" : "Primary Residence Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Hauptwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1950",
      "code" : "ORN",
      "display" : "Other Residence Number",
      "definition" : "Other Residence Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nebenwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1951",
      "code" : "WPN",
      "display" : "Work Number",
      "definition" : "Work Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dienstnummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1952",
      "code" : "VHN",
      "display" : "Vacation Home Number",
      "definition" : "Vacation Home Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ferienwohnsitznummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1953",
      "code" : "ASN",
      "display" : "Answering Service Number",
      "definition" : "Answering Service Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsdienst"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1954",
      "code" : "EMR",
      "display" : "Emergency Number",
      "definition" : "Emergency Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Notfallnummer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1955",
      "code" : "NET",
      "display" : "Network (email) Address",
      "definition" : "Network (email) Address",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Netzwerkadresse (E-Mail)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1956",
      "code" : "BPN",
      "display" : "Beeper Number",
      "definition" : "Beeper Number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Pagernummer (Cityruf o.ä.)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backward compatibility as of v 2.6"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1957",
      "code" : "PRS",
      "display" : "Personal",
      "definition" : "Personal",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Not tied to a location or role"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Not tied to a location or role"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "code" : "DSM",
      "display" : "Direct Secure Messaging",
      "definition" : "Direct Secure Messaging using the Direct Protocol",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
