# addressType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **addressType**

## CodeSystem: addressType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0190 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AddressType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.101 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. 

 
Underlying Master Code System for V2 table 0190 (Address Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAddressType](ValueSet-v2-0190.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0190",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0190",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.101"
    }
  ],
  "version" : "2.0.0",
  "name" : "AddressType",
  "title" : "addressType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying types or kinds of addresses.  Used in HL7 Version 2.x messaging in the XAD segment.",
  "purpose" : "Underlying Master Code System for V2 table 0190 (Address Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0190",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "1890",
      "code" : "BA",
      "display" : "Bad address",
      "definition" : "Bad address",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "ungültige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.17"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.17"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1891",
      "code" : "BI",
      "display" : "Billing Address",
      "definition" : "Billing Address",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Rechnungsadresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "May also be used for the validation/authorization of credit cards"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "May also be used for the validation/authorization of credit cards"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1892",
      "code" : "N",
      "display" : "Birth (nee)  (birth address, not otherwise specified)",
      "definition" : "Birth (nee)  (birth address, not otherwise specified)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to the birth address, not otherwise specified"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to the birth address, not otherwise specified"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1893",
      "code" : "BDL",
      "display" : "Birth delivery location  (address where birth occurred)",
      "definition" : "Birth delivery location  (address where birth occurred)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "genauer Geburtsort"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to the address where birth occurred."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to the address where birth occurred."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1894",
      "code" : "F",
      "display" : "Country Of Origin",
      "definition" : "Country Of Origin",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Herkunftsland"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1895",
      "code" : "C",
      "display" : "Current Or Temporary",
      "definition" : "Current Or Temporary",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Derzeitige Adresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.16"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.16"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1896",
      "code" : "B",
      "display" : "Firm/Business",
      "definition" : "Firm/Business",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Firma/Geschäft"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to an address specific to an organization, such as an insurance company or employer, versus an individual’s work location or place of employment. It would be specific to a firm or organization that has some sort of business relationship with the subject"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to an address specific to an organization, such as an insurance company or employer, versus an individual’s work location or place of employment. It would be specific to a firm or organization that has some sort of business relationship with the subject"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1897",
      "code" : "H",
      "display" : "Home",
      "definition" : "Home",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Privatadresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to a residence or domicile, literally the place where the subject resides the majority of the time. Generally speaking most people will have a home address and it will represent their primary address. Home address is mutually exclusive of permanent address."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to a residence or domicile, literally the place where the subject resides the majority of the time. Generally speaking most people will have a home address and it will represent their primary address. Home address is mutually exclusive of permanent address."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1898",
      "code" : "L",
      "display" : "Legal Address",
      "definition" : "Legal Address",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "registrierte Adresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to a special case address specific to the status of a subject or legal action involving the subject. For example, prisoners being treated at a healthcare facility may have home addresses, but their status mandates an address specific to their place of incarceration. Statutes may require the health information specific to a ward of the state be sent to a legal guardian, the courts, or a state or municipal agency regardless of the ward’s physical location. In cases involving civil or criminal proceedings, a record may be flagged such that all correspondence is sent to any variety of legal entities."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to a special case address specific to the status of a subject or legal action involving the subject. For example, prisoners being treated at a healthcare facility may have home addresses, but their status mandates an address specific to their place of incarceration. Statutes may require the health information specific to a ward of the state be sent to a legal guardian, the courts, or a state or municipal agency regardless of the ward’s physical location. In cases involving civil or criminal proceedings, a record may be flagged such that all correspondence is sent to any variety of legal entities."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1899",
      "code" : "M",
      "display" : "Mailing",
      "definition" : "Mailing",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Postalische Adresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.18"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Retained for backward compatibility only as of v2.6. Refer to XAD.18"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1900",
      "code" : "O",
      "display" : "Office/Business",
      "definition" : "Office/Business",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Büroadresse"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to a work address specific to the subject."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to a work address specific to the subject."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1901",
      "code" : "P",
      "display" : "Permanent",
      "definition" : "Permanent",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Dauernder Wohnsitz"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to a place where the residents know the subject and where correspondence addressed to the subject will eventually reach the subject regardless of their physical location. A permanent address generally reflects a tax jurisdiction.  Members of the military, flight attendants, and executives on rotational assignments are examples of those who typically maintain a permanent address. Although mutually exclusive of home address, in some instances, such as the executives mentioned above, it may be synonymous.  In such cases upon return from assignment this address would revert to the home address."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to a place where the residents know the subject and where correspondence addressed to the subject will eventually reach the subject regardless of their physical location. A permanent address generally reflects a tax jurisdiction.  Members of the military, flight attendants, and executives on rotational assignments are examples of those who typically maintain a permanent address. Although mutually exclusive of home address, in some instances, such as the executives mentioned above, it may be synonymous.  In such cases upon return from assignment this address would revert to the home address."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1902",
      "code" : "RH",
      "display" : "Registry home. Refers to the information system, typically managed by a public health agency, that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services.",
      "definition" : "Registry home. Refers to the information system, typically managed by a public health agency, that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to the information system, typically managed by a public health agency that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to the information system, typically managed by a public health agency that stores patient information such as immunization histories or cancer data, regardless of where the patient obtains services"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1903",
      "code" : "BR",
      "display" : "Residence at birth (home address at time of birth)",
      "definition" : "Residence at birth (home address at time of birth)",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Wohnort zum Zeit­punkt der Geburt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to the home address at time of birth."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to the home address at time of birth."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1904",
      "code" : "S",
      "display" : "Service Location",
      "definition" : "Service Location",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Leistungsort"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Refers to the location in which service is rendered. This would be used if reimbursement is based on the location of the service (to take into account the cost of those services)."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Refers to the location in which service is rendered. This would be used if reimbursement is based on the location of the service (to take into account the cost of those services)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1905",
      "code" : "SH",
      "display" : "Shipping Address",
      "definition" : "Shipping Address",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Versandadresse"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1906",
      "code" : "TM",
      "display" : "Tube Address",
      "definition" : "Tube Address",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Pneumatic tube address (to which letters may be sent). A special transport system to transport small samples/containers and/or normal mail in small carriages on rail or in a tube.  (German Rohrpost)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Pneumatic tube address (to which letters may be sent). A special transport system to transport small samples/containers and/or normal mail in small carriages on rail or in a tube.  (German Rohrpost)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1907",
      "code" : "V",
      "display" : "Vacation",
      "definition" : "Vacation",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Adresse des Ferienortes"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
