# militaryService - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **militaryService**

## CodeSystem: militaryService 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0140 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MilitaryService |
| *Other Identifiers:*OID:2.16.840.1.113883.18.62 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts which specify the military branch. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. 

 
Underlying Master Code System for V2 table 0140 (Military Service) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSMilitaryService](ValueSet-v2-0140.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0140",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0140",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.62"
    }
  ],
  "version" : "2.0.0",
  "name" : "MilitaryService",
  "title" : "militaryService",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify the military branch.  This field is defined by CMS or other regulatory agencies.  Used in HL7 Version 2.x messaging in the PD1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0140 (Military Service)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0140",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "1590",
      "code" : "USA",
      "display" : "US Army",
      "definition" : "US Army",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1591",
      "code" : "USN",
      "display" : "US Navy",
      "definition" : "US Navy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1592",
      "code" : "USAF",
      "display" : "US Air Force",
      "definition" : "US Air Force",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1593",
      "code" : "USMC",
      "display" : "US Marine Corps",
      "definition" : "US Marine Corps",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1594",
      "code" : "USCG",
      "display" : "US Coast Guard",
      "definition" : "US Coast Guard",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1595",
      "code" : "USPHS",
      "display" : "US Public Health Service",
      "definition" : "US Public Health Service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1596",
      "code" : "NOAA",
      "display" : "National Oceanic and Atmospheric Administration",
      "definition" : "National Oceanic and Atmospheric Administration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1597",
      "code" : "NATO",
      "display" : "North Atlantic Treaty Organization",
      "definition" : "North Atlantic Treaty Organization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1598",
      "code" : "AUSA",
      "display" : "Australian Army",
      "definition" : "Australian Army",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1599",
      "code" : "AUSN",
      "display" : "Australian Navy",
      "definition" : "Australian Navy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1600",
      "code" : "AUSAF",
      "display" : "Australian Air Force",
      "definition" : "Australian Air Force",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
