# SubscriptionTag - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubscriptionTag**

## CodeSystem: SubscriptionTag 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/subscription-tag | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubscriptionTag |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1141 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Tags to put on a resource after subscriptions have been sent. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubscriptionTag](ValueSet-subscription-tag.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subscription-tag",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/subscription-tag",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1141"
    }
  ],
  "version" : "1.0.0",
  "name" : "SubscriptionTag",
  "title" : "SubscriptionTag",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Tags to put on a resource after subscriptions have been sent.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/subscription-tag",
  "content" : "complete",
  "concept" : [
    {
      "code" : "queued",
      "display" : "Queued",
      "definition" : "The message has been queued for processing on a destination systems."
    },
    {
      "code" : "delivered",
      "display" : "Delivered",
      "definition" : "The message has been delivered to its intended recipient."
    }
  ]
}

```
