# SubscriberPolicyholder Relationship Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubscriberPolicyholder Relationship Codes**

## CodeSystem: SubscriberPolicyholder Relationship Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/subscriber-relationship | *Version*:1.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubscriberRelationshipCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1386 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubscriberRelationshipCodes](ValueSet-subscriber-relationship.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subscriber-relationship",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1386"
    }
  ],
  "version" : "1.0.1",
  "name" : "SubscriberRelationshipCodes",
  "title" : "SubscriberPolicyholder Relationship Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/subscriber-relationship",
  "content" : "complete",
  "concept" : [
    {
      "code" : "child",
      "display" : "Child",
      "definition" : "The Beneficiary is a child of the Subscriber"
    },
    {
      "code" : "parent",
      "display" : "Parent",
      "definition" : "The Beneficiary is a parent of the Subscriber"
    },
    {
      "code" : "spouse",
      "display" : "Spouse",
      "definition" : "The Beneficiary is a spouse or equivalent of the Subscriber"
    },
    {
      "code" : "common",
      "display" : "Common Law Spouse",
      "definition" : "The Beneficiary is a common law spouse or equivalent of the Subscriber"
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "The Beneficiary has some other relationship the Subscriber"
    },
    {
      "code" : "self",
      "display" : "Self",
      "definition" : "The Beneficiary is the Subscriber"
    },
    {
      "code" : "injured",
      "display" : "Injured Party",
      "definition" : "The Beneficiary is covered under insurance of the subscriber due to an injury."
    }
  ]
}

```
