# StatisticStudyType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticStudyType**

## CodeSystem: StatisticStudyType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/study-type | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticStudyType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1350 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The type of study a statistic was derived from. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticStudyType](ValueSet-study-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "study-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/study-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1350"
    }
  ],
  "version" : "1.0.0",
  "name" : "StatisticStudyType",
  "title" : "StatisticStudyType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of study a statistic was derived from.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/study-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "RCT",
      "display" : "randomized trial",
      "definition" : "randomized controlled trial."
    },
    {
      "code" : "CCT",
      "display" : "controlled trial (non-randomized)",
      "definition" : "controlled (but not randomized) trial."
    },
    {
      "code" : "cohort",
      "display" : "comparative cohort study",
      "definition" : "observational study comparing cohorts."
    },
    {
      "code" : "case-control",
      "display" : "case-control study",
      "definition" : "case-control study."
    },
    {
      "code" : "series",
      "display" : "uncontrolled case series",
      "definition" : "uncontrolled case series."
    },
    {
      "code" : "case-report",
      "display" : "case report",
      "definition" : "a single case report."
    },
    {
      "code" : "RCTandCohort",
      "display" : "mixed RCT and cohort",
      "definition" : "a combination of 1 or more RCTs and cohorts."
    },
    {
      "code" : "cross-section",
      "display" : "cross sectional study",
      "definition" : "uncontrolled cohort."
    }
  ]
}

```
