# Software System Type Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Software System Type Codes**

## CodeSystem: Software System Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/software-system-type-codes | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SoftwareSystemTypeCodes |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SoftwareSystemType](ValueSet-software-system-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "software-system-type-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/software-system-type-codes",
  "version" : "1.0.0",
  "name" : "SoftwareSystemTypeCodes",
  "title" : "Software System Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/software-system-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "authoring",
      "display" : "Authoring",
      "definition" : "A knowledge authoring environment"
    },
    {
      "code" : "testing",
      "display" : "Testing",
      "definition" : "A testing environment"
    },
    {
      "code" : "tooling",
      "display" : "Tooling",
      "definition" : "Tooling software"
    },
    {
      "code" : "evaluation",
      "display" : "Evaluation",
      "definition" : "A knowledge evaluation environment"
    },
    {
      "code" : "reporting",
      "display" : "Reporting",
      "definition" : "A quality reporting system"
    },
    {
      "code" : "data-capture",
      "display" : "Data Capture",
      "definition" : "A system that performs data-capture as part of a reporting pipeline"
    }
  ]
}

```
