# SmartCapabilities - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SmartCapabilities**

## CodeSystem: SmartCapabilities 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/smart-capabilities | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SmartCapabilities |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1265 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
Codes that define what the server is capable of. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SmartCapabilities](ValueSet-smart-capabilities.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "smart-capabilities",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/smart-capabilities",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1265"
    }
  ],
  "version" : "1.0.1",
  "name" : "SmartCapabilities",
  "title" : "SmartCapabilities",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes that define what the server is capable of.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/smart-capabilities",
  "content" : "complete",
  "concept" : [
    {
      "code" : "launch-ehr",
      "display" : "EHR Launch Mode",
      "definition" : "support for SMART’s EHR Launch mode."
    },
    {
      "code" : "launch-standalone",
      "display" : "Standalone Launch Mode",
      "definition" : "support for SMART’s Standalone Launch mode."
    },
    {
      "code" : "client-public",
      "display" : "Public Client Profile",
      "definition" : "support for SMART’s public client profile (no client authentication)."
    },
    {
      "code" : "client-confidential-symmetric",
      "display" : "Confidential Client Profile",
      "definition" : "support for SMART’s confidential client profile (symmetric client secret authentication)."
    },
    {
      "code" : "sso-openid-connect",
      "display" : "Supports OpenID Connect",
      "definition" : "support for SMART’s OpenID Connect profile."
    },
    {
      "code" : "context-passthrough-banner",
      "display" : "Allows \"Need Patient Banner\"",
      "definition" : "support for “need patient banner” launch context (conveyed via need_patient_banner token parameter)."
    },
    {
      "code" : "context-passthrough-style",
      "display" : "Allows \"Smart Style Style\"",
      "definition" : "support for “SMART style URL” launch context (conveyed via smart_style_url token parameter)."
    },
    {
      "code" : "context-ehr-patient",
      "display" : "Allows \"Patient Level Launch Context (EHR)\"",
      "definition" : "support for patient-level launch context (requested by launch/patient scope, conveyed via patient token parameter)."
    },
    {
      "code" : "context-ehr-encounter",
      "display" : "Allows \"Encounter Level Launch Context (EHR)\"",
      "definition" : "support for encounter-level launch context (requested by launch/encounter scope, conveyed via encounter token parameter)."
    },
    {
      "code" : "context-standalone-patient",
      "display" : "Allows \"Patient Level Launch Context (STANDALONE)\"",
      "definition" : "support for patient-level launch context (requested by launch/patient scope, conveyed via patient token parameter)."
    },
    {
      "code" : "context-standalone-encounter",
      "display" : "Allows \"Encounter Level Launch Context (STANDALONE)\"",
      "definition" : "support for encounter-level launch context (requested by launch/encounter scope, conveyed via encounter token parameter)."
    },
    {
      "code" : "permission-offline",
      "display" : "Supports Refresh Token",
      "definition" : "support for refresh tokens (requested by offline_access scope)."
    },
    {
      "code" : "permission-patient",
      "display" : "Supports Patient Level Scopes",
      "definition" : "support for patient-level scopes (e.g. patient/Observation.read)."
    },
    {
      "code" : "permission-user",
      "display" : "Supports User Level Scopes",
      "definition" : "support for user-level scopes (e.g. user/Appointment.read)."
    }
  ]
}

```
