# ResearchStudyReasonStopped - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchStudyReasonStopped**

## CodeSystem: ResearchStudyReasonStopped 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-reason-stopped | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyReasonStopped |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1249 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Codes for why the study ended prematurely. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyReasonStopped](ValueSet-research-study-reason-stopped.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-reason-stopped",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-reason-stopped",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1249"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyReasonStopped",
  "title" : "ResearchStudyReasonStopped",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for why the study ended prematurely.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-reason-stopped",
  "content" : "complete",
  "concept" : [
    {
      "code" : "accrual-goal-met",
      "display" : "Accrual Goal Met",
      "definition" : "The study prematurely ended because the accrual goal was met."
    },
    {
      "code" : "closed-due-to-toxicity",
      "display" : "Closed due to toxicity",
      "definition" : "The study prematurely ended due to toxicity."
    },
    {
      "code" : "closed-due-to-lack-of-study-progress",
      "display" : "Closed due to lack of study progress",
      "definition" : "The study prematurely ended due to lack of study progress."
    },
    {
      "code" : "temporarily-closed-per-study-design",
      "display" : "Temporarily closed per study design",
      "definition" : "The study prematurely ended temporarily per study design."
    }
  ]
}

```
