# Research Study Party Role - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Research Study Party Role**

## CodeSystem: Research Study Party Role 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-party-role | *Version*:1.0.0 | | |
| Active as of 2025-11-14 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyPartyRole |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.4.1968 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This is a ResearchStudy's party role. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyPartyRole](ValueSet-research-study-party-role.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-party-role",
  "meta" : {
    "lastUpdated" : "2025-11-14T20:54:02+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-party-role",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.4.1968"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyPartyRole",
  "title" : "Research Study Party Role",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-14T12:40:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This is a ResearchStudy's party role.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-party-role",
  "content" : "complete",
  "concept" : [
    {
      "code" : "sponsor",
      "display" : "Sponsor",
      "definition" : "Person, company, agency or institution that initiates a clinical investigation      and takes responsibility for that investigation but does not conduct the investigation."
    },
    {
      "code" : "lead-sponsor",
      "display" : "Lead sponsor",
      "definition" : "Primary person, company, agency or institution that initiates a clinical investigation      and takes responsibility for that investigation but does not conduct the investigation      if there is more than one sponsor."
    },
    {
      "code" : "sponsor-investigator",
      "display" : "Sponsor-investigator",
      "definition" : "Entity who both initiates and conducts an investigation."
    },
    {
      "code" : "primary-investigator",
      "display" : "Principal investigator",
      "definition" : "An investigator who is responsible for all aspects of the conduct of a study."
    },
    {
      "code" : "collaborator",
      "display" : "Collaborator",
      "definition" : "An organization or individual, who contributes to a study by providing support      to the primary investigator to conduct research."
    },
    {
      "code" : "funding-source",
      "display" : "Funding source",
      "definition" : "An organization that underwrites financial support for the research study."
    },
    {
      "code" : "general-contact",
      "display" : "General contact",
      "definition" : "Information for the person who can answer general questions for a study."
    },
    {
      "code" : "recruitment-contact",
      "display" : "Recruitment contact",
      "definition" : "Information for the person who can answer recruitment questions for a study."
    },
    {
      "code" : "sub-investigator",
      "display" : "Sub-investigator",
      "definition" : "Any individual member of the clinical trial team designated and supervised by the investigator at a trial site to perform critical trial-related procedures and/or to make important trial-related decisions (e.g., associates, residents, research fellows)."
    },
    {
      "code" : "study-chair",
      "display" : "Study chair",
      "definition" : "An individual person who both initiates and conducts, alone or with others, a clinical trial and under whose immediate direction the investigational product is administered to, dispensed to, or used by a subject. (Also called study director or study chairperson)"
    },
    {
      "code" : "irb",
      "display" : "Institutional Review Board",
      "definition" : "A group of individuals that reviews and monitors research involving human subjects."
    },
    {
      "code" : "data-monitoring",
      "display" : "Data Monitoring",
      "definition" : "An organization or individual who monitors the validity and integrity of collected data while prioritizing participant safety and study integrity. The organization may be called a Data Monitoring Committee (DMC) or Data and Safety Monitoring Board (DSMB)."
    }
  ]
}

```
