# Provenance participant type - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provenance participant type**

## CodeSystem: Provenance participant type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/provenance-participant-type | *Version*:2.0.0 | | |
| Active as of 2024-06-28 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProvenanceParticipantType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1131 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
These codes define the type of participation by an agent in a provenance activity. An agent is something that bears the responsibility identified by the type of participation in the activity taking place, for the existence of an entity, or for another agent's activity. An Agent may be An agent, device, system, organization, group, care-team, or other identifiable thing. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ProvenanceParticipantType](ValueSet-provenance-agent-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "provenance-participant-type",
  "meta" : {
    "lastUpdated" : "2024-06-28T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sec"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1131"
    }
  ],
  "version" : "2.0.0",
  "name" : "ProvenanceParticipantType",
  "title" : "Provenance participant type",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-06-28T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "These codes define the type of participation by an agent in a provenance activity. An agent is something that bears the responsibility identified by the type of participation in the activity taking place, for the existence of an entity, or for another agent's activity. An Agent may be An agent, device, system, organization, group, care-team, or other identifiable thing.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/provenance-agent-type",
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "enterer",
      "display" : "Enterer",
      "definition" : "An agent entering the data into the originating system, such as a scribe or transcriptionist."
    },
    {
      "code" : "performer",
      "display" : "Performer",
      "definition" : "An agent that who actually and principally carries out the activity"
    },
    {
      "code" : "author",
      "display" : "Author",
      "definition" : "An agent that originates, or significant changes to, the entity and therefore has responsibility for the information given in the entity",
      "concept" : [
        {
          "code" : "editor",
          "display" : "Editor",
          "definition" : "An agent that alters the entity to change, correct, or enhance the original"
        }
      ]
    },
    {
      "code" : "verifier",
      "display" : "Verifier",
      "definition" : "An agent who verifies the correctness and appropriateness of activity",
      "concept" : [
        {
          "code" : "legal",
          "display" : "Legal Authenticator",
          "definition" : "An agent authenticated the content and accepted legal responsibility for its content"
        }
      ]
    },
    {
      "code" : "attester",
      "display" : "Attester",
      "definition" : "An agent (verifier) who attests to the accuracy of the entity"
    },
    {
      "code" : "informant",
      "display" : "Informant",
      "definition" : "An agent who reported information that contributed to the entity"
    },
    {
      "code" : "custodian",
      "display" : "Custodian",
      "definition" : "The entity that is accountable for maintaining a true an accurate copy of the original record"
    },
    {
      "code" : "transmitter",
      "display" : "Transmitter",
      "definition" : "The entity that provided the copy to your system."
    },
    {
      "code" : "assembler",
      "display" : "Assembler",
      "definition" : "A device that operates independently of an author using algorithms for data extraction of existing information for purpose of generating a new entity.",
      "concept" : [
        {
          "code" : "transformer",
          "display" : "Transformer",
          "definition" : "A device that operates independently of an author using algorithms for data extraction and transformation of existing information for purpose of generating a new entity."
        }
      ]
    },
    {
      "code" : "composer",
      "display" : "Composer",
      "definition" : "A device used by an author to record new information, which may also be used by the author to select existing information for aggregation with newly recorded information for the purpose of generating a new entity."
    }
  ]
}

```
