# DeviceDefinitionParameterGroup - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceDefinitionParameterGroup**

## CodeSystem: DeviceDefinitionParameterGroup 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/parameter-group | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DeviceDefinitionParameterGroup |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1264 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes identifying groupings of parameters; e.g. Cardiovascular. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DeviceDefinitionParameterGroup](ValueSet-parameter-group.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "parameter-group",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/parameter-group",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1264"
    }
  ],
  "version" : "1.0.0",
  "name" : "DeviceDefinitionParameterGroup",
  "title" : "DeviceDefinitionParameterGroup",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes identifying groupings of parameters; e.g. Cardiovascular.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/parameter-group",
  "content" : "complete",
  "concept" : [
    {
      "code" : "haemodynamic",
      "display" : "Haemodynamic Parameter Group",
      "definition" : "Haemodynamic Parameter Group - MDC_PGRP_HEMO."
    },
    {
      "code" : "ecg",
      "display" : "ECG Parameter Group",
      "definition" : "ECG Parameter Group - MDC_PGRP_ECG."
    },
    {
      "code" : "respiratory",
      "display" : "Respiratory Parameter Group",
      "definition" : "Respiratory Parameter Group - MDC_PGRP_RESP."
    },
    {
      "code" : "ventilation",
      "display" : "Ventilation Parameter Group",
      "definition" : "Ventilation Parameter Group - MDC_PGRP_VENT."
    },
    {
      "code" : "neurological",
      "display" : "Neurological Parameter Group",
      "definition" : "Neurological Parameter Group - MDC_PGRP_NEURO."
    },
    {
      "code" : "drug-delivery",
      "display" : "Drug Delivery Parameter Group",
      "definition" : "Drug Delivery Parameter Group - MDC_PGRP_DRUG."
    },
    {
      "code" : "fluid-chemistry",
      "display" : "Fluid Chemistry Parameter Group",
      "definition" : "Fluid Chemistry Parameter Group - MDC_PGRP_FLUID."
    },
    {
      "code" : "blood-chemistry",
      "display" : "Blood Chemistry Parameter Group",
      "definition" : "Blood Chemistry Parameter Group - MDC_PGRP_BLOOD_CHEM."
    },
    {
      "code" : "miscellaneous",
      "display" : "Miscellaneous Parameter Group",
      "definition" : "Miscellaneous Parameter Group - MDC_PGRP_MISC."
    }
  ]
}

```
