# HumanNameAssemblyOrder - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HumanNameAssemblyOrder**

## CodeSystem: HumanNameAssemblyOrder 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/name-assembly-order | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HumanNameAssemblyOrder |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1266 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
A code that represents the preferred display order of the components of a human name. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "name-assembly-order",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/name-assembly-order",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1266"
    }
  ],
  "version" : "1.0.1",
  "name" : "HumanNameAssemblyOrder",
  "title" : "HumanNameAssemblyOrder",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code that represents the preferred display order of the components of a human name.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "NL1",
      "display" : "Own Name"
    },
    {
      "code" : "NL2",
      "display" : "Partner Name"
    },
    {
      "code" : "NL3",
      "display" : "Partner Name followed by Maiden Name"
    },
    {
      "code" : "NL4",
      "display" : "Own Name followed by Partner Name"
    }
  ]
}

```
