# MedicationKnowledge Package Type Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationKnowledge Package Type Codes**

## CodeSystem: MedicationKnowledge Package Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationknowledge-package-type | *Version*:1.0.0 | | |
| Draft as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationKnowledgePackageTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1340 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
MedicationKnowledge Package Type Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationKnowledgePackageTypeCodes](ValueSet-medicationknowledge-package-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationknowledge-package-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationknowledge-package-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1340"
    }
  ],
  "version" : "1.0.0",
  "name" : "MedicationKnowledgePackageTypeCodes",
  "title" : "MedicationKnowledge Package Type Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationKnowledge Package Type Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationknowledge-package-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "amp",
      "display" : "Ampule"
    },
    {
      "code" : "bag",
      "display" : "Bag"
    },
    {
      "code" : "blstrpk",
      "display" : "Blister Pack"
    },
    {
      "code" : "bot",
      "display" : "Bottle"
    },
    {
      "code" : "box",
      "display" : "Box"
    },
    {
      "code" : "can",
      "display" : "Can"
    },
    {
      "code" : "cart",
      "display" : "Cartridge"
    },
    {
      "code" : "disk",
      "display" : "Disk"
    },
    {
      "code" : "doset",
      "display" : "Dosette"
    },
    {
      "code" : "jar",
      "display" : "Jar"
    },
    {
      "code" : "jug",
      "display" : "Jug"
    },
    {
      "code" : "minim",
      "display" : "Minim"
    },
    {
      "code" : "nebamp",
      "display" : "Nebule Amp"
    },
    {
      "code" : "ovul",
      "display" : "Ovule"
    },
    {
      "code" : "pch",
      "display" : "Pouch"
    },
    {
      "code" : "pkt",
      "display" : "Packet"
    },
    {
      "code" : "sash",
      "display" : "Sashet"
    },
    {
      "code" : "strip",
      "display" : "Strip"
    },
    {
      "code" : "tin",
      "display" : "Tin"
    },
    {
      "code" : "tub",
      "display" : "Tub"
    },
    {
      "code" : "tube",
      "display" : "Tube"
    },
    {
      "code" : "vial",
      "display" : "Vial"
    }
  ]
}

```
