# Medical Management Type - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medical Management Type**

## CodeSystem: Medical Management Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medical-management-type | *Version*:1.0.0 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicalManagementType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.175 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicalManagementType](ValueSet-medical-management-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medical-management-type",
  "meta" : {
    "lastUpdated" : "2025-05-26T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medical-management-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.175"
    }
  ],
  "version" : "1.0.0",
  "name" : "MedicalManagementType",
  "title" : "Medical Management Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medical-management-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "concurrent-review",
      "display" : "Concurrent Review",
      "definition" : "Review of medical necessity while the patient is actively receiving treatment."
    },
    {
      "code" : "prior-auth",
      "display" : "Prior Authorization",
      "definition" : "Review of medical necessity prior to receiving treatment."
    },
    {
      "code" : "step-therapy",
      "display" : "Step Therapy (Fail First)",
      "definition" : "Requirement that lower cost or preferred treatments be tried, or perhaps contra-indicated, before alternatives are utilized. This policy is sometimes referred to as 'fail first'."
    }
  ]
}

```
