# Measure Scoring - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Scoring**

## CodeSystem: Measure Scoring 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-scoring | *Version*:4.0.0 | | |
| Active as of 2021-03-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureScoring |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1232 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The scoring type of the measure. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureScoring](ValueSet-measure-scoring.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-scoring",
  "meta" : {
    "lastUpdated" : "2021-03-26T11:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1232"
    }
  ],
  "version" : "4.0.0",
  "name" : "MeasureScoring",
  "title" : "Measure Scoring",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-03-26T11:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The scoring type of the measure.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/measure-scoring",
  "content" : "complete",
  "concept" : [
    {
      "code" : "attestation",
      "display" : "Attestation",
      "definition" : "The measure is an attestation, meaning that the reporter of the measure is attesting the measure score. This is typically used for true/false attestations, but can be used for other types of measure scores as well. The key distinction is that the measure is not computably represented (i.e. as a calculation or aggregation performed on some data in the reporting system), but rather is a simple attestation made by the measure reporter."
    },
    {
      "code" : "proportion",
      "display" : "Proportion",
      "definition" : "The measure is a proportion scoring measure, defined as the result of a fraction (number of events in the numerator divided by the number of events in the denominator). Proportion measures typically define an initial population, then denominator and numerator inclusion and exclusion criteria."
    },
    {
      "code" : "ratio",
      "display" : "Ratio",
      "definition" : "The measure is a ratio scoring measure, defined as the result of a ratio calculation. This is similar to a proportion scoring, with the exception that the numerator and denominator may be drawn from different initial populations. Ratio measures typically define initial population(s) and then numerator and denominator inclusion and exclusion criteria."
    },
    {
      "code" : "continuous-variable",
      "display" : "Continuous Variable",
      "definition" : "The measure is a continuous variable scoring measure, defined by a measure observation calculation performed for each member of the population. Continuous variable measures typically define an initial population, then measure population inclusion and exclusion criteria, as well as a measure observation."
    },
    {
      "code" : "cohort",
      "display" : "Cohort",
      "definition" : "The measure is a cohort definition, meaning the measure is simply the definition of a population, and the score is a count of the members of that population. Cohort measures typically define only an initial population to determine membership."
    },
    {
      "code" : "composite",
      "display" : "Composite",
      "definition" : "The measure score combines multiple component measures into a single measure score. Composite measures are typically defined by referencing other measures, and use the Composite Scoring code system to define possible composite scoring methods."
    }
  ]
}

```
