# HandlingConditionSet - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HandlingConditionSet**

## CodeSystem: HandlingConditionSet 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/handling-condition | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HandlingConditionSet |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1259 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Set of handling instructions prior testing of the specimen. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HandlingConditionSet](ValueSet-handling-condition.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "handling-condition",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/handling-condition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1259"
    }
  ],
  "version" : "1.0.1",
  "name" : "HandlingConditionSet",
  "title" : "HandlingConditionSet",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Set of handling instructions prior testing of the specimen.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/handling-condition",
  "content" : "complete",
  "concept" : [
    {
      "code" : "room",
      "display" : "room temperature",
      "definition" : "room temperature."
    },
    {
      "code" : "refrigerated",
      "display" : "refrigerated",
      "definition" : "refrigerated temperature."
    },
    {
      "code" : "frozen",
      "display" : "frozen",
      "definition" : "frozen temperature."
    }
  ]
}

```
