# Example Service Place Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Service Place Codes**

## CodeSystem: Example Service Place Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-serviceplace | *Version*:1.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleServicePlaceCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1157 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes a smattering of Service Place codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleServicePlaceCodes](ValueSet-service-place.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-serviceplace",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-serviceplace",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1157"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleServicePlaceCodes",
  "title" : "Example Service Place Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of Service Place codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/service-place",
  "content" : "complete",
  "concept" : [
    {
      "code" : "01",
      "display" : "Pharmacy",
      "definition" : "A facility or location where drugs and other medically related items and services are sold, dispensed, or otherwise provided directly to patients."
    },
    {
      "code" : "03",
      "display" : "School",
      "definition" : "A facility whose primary purpose is education."
    },
    {
      "code" : "04",
      "display" : "Homeless Shelter",
      "definition" : "A facility or location whose primary purpose is to provide temporary housing to homeless individuals (e.g., emergency shelters, individual or family shelters)."
    },
    {
      "code" : "05",
      "display" : "Indian Health Service Free-standing Facility",
      "definition" : "A facility or location, owned and operated by the Indian Health Service, which provides diagnostic, therapeutic (surgical and nonsurgical), and rehabilitation services to American Indians and Alaska Natives who do not require hospitalization."
    },
    {
      "code" : "06",
      "display" : "Indian Health Service Provider-based Facility",
      "definition" : "A facility or location, owned and operated by the Indian Health Service, which provides diagnostic, therapeutic (surgical and nonsurgical), and rehabilitation services rendered by, or under the supervision of, physicians to American Indians and Alaska Natives admitted as inpatients or outpatients."
    },
    {
      "code" : "07",
      "display" : "Tribal 638 Free-Standing Facility",
      "definition" : "A facility or location owned and operated by a federally recognized American Indian or Alaska Native tribe or tribal organization under a 638 agreement, which provides diagnostic, therapeutic (surgical and nonsurgical), and rehabilitation services to tribal members who do not require hospitalization."
    },
    {
      "code" : "08",
      "display" : "Tribal 638 Provider-Based Facility",
      "definition" : "A facility or location owned and operated by a federally recognized American Indian or Alaska Native tribe or tribal organization under a 638 agreement, which provides diagnostic, therapeutic (surgical and nonsurgical), and rehabilitation services to tribal members admitted as inpatients or outpatients."
    },
    {
      "code" : "09",
      "display" : "Prison/Correctional Facility",
      "definition" : "A prison, jail, reformatory, work farm, detention center, or any other similar facility maintained by either Federal, State or local authorities for the purpose of confinement or rehabilitation of adult or juvenile criminal offenders."
    },
    {
      "code" : "11",
      "display" : "Office",
      "definition" : "Location, other than a hospital, skilled nursing facility (SNF), military treatment facility, community health center, State or local public health clinic, or intermediate care facility (ICF), where the health professional routinely provides health examinations, diagnosis, and treatment of illness or injury on an ambulatory basis."
    },
    {
      "code" : "12",
      "display" : "Home",
      "definition" : "Location, other than a hospital or other facility, where the patient receives care in a private residence."
    },
    {
      "code" : "13",
      "display" : "Assisted Living Fa",
      "definition" : "Congregate residential facility with self-contained living units providing assessment of each resident's needs and on-site support 24 hours a day, 7 days a week, with the capacity to deliver or arrange for services including some health care and other services."
    },
    {
      "code" : "14",
      "display" : "Group Home",
      "definition" : "A residence, with shared living areas, where clients receive supervision and other services such as social and/or behavioral services, custodial service, and minimal services (e.g., medication administration)."
    },
    {
      "code" : "15",
      "display" : "Mobile Unit",
      "definition" : "A facility/unit that moves from place-to-place equipped to provide preventive, screening, diagnostic, and/or treatment services."
    },
    {
      "code" : "19",
      "display" : "Off Campus-Outpatient Hospital",
      "definition" : "portion of an off-campus hospital provider-based department which provides diagnostic, therapeutic (both surgical and nonsurgical), and rehabilitation services to sick or injured persons who do not require hospitalization or institutionalization."
    },
    {
      "code" : "20",
      "display" : "Urgent Care Facility",
      "definition" : "Location, distinct from a hospital emergency room, an office, or a clinic, whose purpose is to diagnose and treat illness or injury for unscheduled, ambulatory patients seeking immediate medical attention."
    },
    {
      "code" : "21",
      "display" : "Inpatient Hospital",
      "definition" : "A facility, other than psychiatric, which primarily provides diagnostic, therapeutic (both surgical and nonsurgical), and rehabilitation services by, or under, the supervision of physicians to patients admitted for a variety of medical conditions."
    },
    {
      "code" : "41",
      "display" : "Ambulance—Land",
      "definition" : "A land vehicle specifically designed, equipped and staffed for lifesaving and transporting the sick or injured."
    }
  ]
}

```
