# Special arrangements - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Special arrangements**

## CodeSystem: Special arrangements 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/encounter-special-arrangements | *Version*:1.0.1 | |
| Active as of 2025-11-15 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecialArrangements |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1090 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SpecialArrangements](ValueSet-encounter-special-arrangements.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "encounter-special-arrangements",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/encounter-special-arrangements",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1090"
    }
  ],
  "version" : "1.0.1",
  "name" : "SpecialArrangements",
  "title" : "Special arrangements",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/encounter-special-arrangements",
  "content" : "complete",
  "concept" : [
    {
      "code" : "wheel",
      "display" : "Wheelchair",
      "definition" : "The patient requires a wheelchair to be made available for the encounter."
    },
    {
      "code" : "add-bed",
      "display" : "Additional bedding",
      "definition" : "An additional bed made available for a person accompanying the patient, for example a parent accompanying a child."
    },
    {
      "code" : "int",
      "display" : "Interpreter",
      "definition" : "The patient is not fluent in the local language and requires an interpreter to be available. Refer to the Patient.Language property for the type of interpreter required."
    },
    {
      "code" : "att",
      "display" : "Attendant",
      "definition" : "A person who accompanies a patient to provide assistive services necessary for the patient's care during the encounter."
    },
    {
      "code" : "dog",
      "display" : "Guide dog",
      "definition" : "The patient has a guide dog and the location used for the encounter should be able to support the presence of the service animal."
    }
  ]
}

```
