# Diagnosis Role - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diagnosis Role**

## CodeSystem: Diagnosis Role 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/diagnosis-role | *Version*:1.1.1 | |
| Active as of 2025-11-15 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DiagnosisRole |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1054 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DiagnosisRole](ValueSet-diagnosis-role.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "diagnosis-role",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/diagnosis-role",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1054"
    }
  ],
  "version" : "1.1.1",
  "name" : "DiagnosisRole",
  "title" : "Diagnosis Role",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/diagnosis-role",
  "content" : "complete",
  "concept" : [
    {
      "code" : "AD",
      "display" : "Admission diagnosis",
      "definition" : "The diagnoses documented for administrative purposes as the basis for a hospital or other institutional admission"
    },
    {
      "code" : "DD",
      "display" : "Discharge diagnosis",
      "definition" : "The diagnoses documented for administrative purposes at the time of hospital or other institutional discharge"
    },
    {
      "code" : "CC",
      "display" : "Chief complaint"
    },
    {
      "code" : "CM",
      "display" : "Comorbidity diagnosis"
    },
    {
      "code" : "pre-op",
      "display" : "pre-op diagnosis"
    },
    {
      "code" : "post-op",
      "display" : "post-op diagnosis"
    },
    {
      "code" : "billing",
      "display" : "Billing",
      "definition" : "The diagnosis documented for billing purposes"
    }
  ]
}

```
