# DeviceAssociation Status Reason Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceAssociation Status Reason Codes**

## CodeSystem: DeviceAssociation Status Reason Codes 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/deviceassociation-status-reason | *Version*:1.0.0 |
| Active as of 2025-11-15 | *Computable Name*:DeviceAssociationStatusReason |

 
DeviceAssociation Status Reason Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "deviceassociation-status-reason",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/deviceassociation-status-reason",
  "version" : "1.0.0",
  "name" : "DeviceAssociationStatusReason",
  "title" : "DeviceAssociation Status Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "description" : "DeviceAssociation Status Reason Codes",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "attached",
      "display" : "Attached",
      "definition" : "The device is connected to the patient."
    },
    {
      "code" : "disconnected",
      "display" : "Disconnected",
      "definition" : "The device is no longer connected."
    },
    {
      "code" : "failed",
      "display" : "Failed",
      "definition" : "The device has failed to work, or continue to function."
    },
    {
      "code" : "placed",
      "display" : "placed",
      "definition" : "The device was placed in the patient."
    },
    {
      "code" : "replaced",
      "display" : "Replaced",
      "definition" : "The device was updated with a new device or device part."
    }
  ]
}

```
