# DeviceAssociation Relationship Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceAssociation Relationship Codes**

## CodeSystem: DeviceAssociation Relationship Codes 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/deviceassociation-relationship | *Version*:1.0.0 |
| Active as of 2025-11-15 | *Computable Name*:DeviceAssociationRelationship |

 
DeviceAssociation Relationship Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "deviceassociation-relationship",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/deviceassociation-relationship",
  "version" : "1.0.0",
  "name" : "DeviceAssociationRelationship",
  "title" : "DeviceAssociation Relationship Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "description" : "DeviceAssociation Relationship Codes",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "owner",
      "display" : "Owner",
      "definition" : "Owner of the device."
    },
    {
      "code" : "custodian",
      "display" : "Custodian",
      "definition" : "The individual or organization who has responsibility for taking care of the device."
    },
    {
      "code" : "maintainer",
      "display" : "Maintainer",
      "definition" : "The individual or organization that keeps the device in an appropriate condition."
    },
    {
      "code" : "patient",
      "display" : "Patient",
      "definition" : "The patient in which the device is implanted, or to which the device is associated."
    },
    {
      "code" : "operator",
      "display" : "Operator",
      "definition" : "The person operating the device."
    }
  ]
}

```
