# Consent Scope Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent Scope Codes**

## CodeSystem: Consent Scope Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/consentscope | *Version*:2.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConsentScopeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1228 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes the four Consent scope codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConsentScopeCodes](ValueSet-consent-scope.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "consentscope",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cbcc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/consentscope",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1228"
    }
  ],
  "version" : "2.0.1",
  "name" : "ConsentScopeCodes",
  "title" : "Consent Scope Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes the four Consent scope codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/consent-scope",
  "content" : "complete",
  "concept" : [
    {
      "code" : "adr",
      "display" : "Advanced Care Directive",
      "definition" : "Actions to be taken if they are no longer able to make decisions for themselves"
    },
    {
      "code" : "research",
      "display" : "Research",
      "definition" : "Consent to participate in research protocol and information sharing required"
    },
    {
      "code" : "patient-privacy",
      "display" : "Privacy Consent",
      "definition" : "Agreement to collect, access, use or disclose (share) information"
    },
    {
      "code" : "treatment",
      "display" : "Treatment",
      "definition" : "Consent to undergo a specific treatment"
    }
  ]
}

```
