# CommunicationNotDoneReason - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CommunicationNotDoneReason**

## CodeSystem: CommunicationNotDoneReason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/communication-not-done-reason | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CommunicationNotDoneReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1077 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes for the reason why a communication did not happen. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CommunicationNotDoneReason](ValueSet-communication-not-done-reason.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "communication-not-done-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/communication-not-done-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1077"
    }
  ],
  "version" : "1.0.1",
  "name" : "CommunicationNotDoneReason",
  "title" : "CommunicationNotDoneReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the reason why a communication did not happen.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/communication-not-done-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "The communication was not done due to an unknown reason."
    },
    {
      "code" : "system-error",
      "display" : "System Error",
      "definition" : "The communication was not done due to a system error."
    },
    {
      "code" : "invalid-phone-number",
      "display" : "Invalid Phone Number",
      "definition" : "The communication was not done due to an invalid phone number."
    },
    {
      "code" : "recipient-unavailable",
      "display" : "Recipient Unavailable",
      "definition" : "The communication was not done due to the recipient being unavailable."
    },
    {
      "code" : "family-objection",
      "display" : "Family Objection",
      "definition" : "The communication was not done due to a family objection."
    },
    {
      "code" : "patient-objection",
      "display" : "Patient Objection",
      "definition" : "The communication was not done due to a patient objection."
    }
  ]
}

```
