# Cited Artifact Classification Type - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cited Artifact Classification Type**

## CodeSystem: Cited Artifact Classification Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/cited-artifact-classification-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:CitedArtifactClassificationType |

 
Cited Artifact Classification Type 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitedArtifactClassificationType](ValueSet-cited-artifact-classification-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cited-artifact-classification-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/cited-artifact-classification-type",
  "version" : "1.0.0",
  "name" : "CitedArtifactClassificationType",
  "title" : "Cited Artifact Classification Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T10:55:11.085+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Cited Artifact Classification Type",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/cited-artifact-classification-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "publication-type",
      "display" : "Publication type",
      "definition" : "Publication type"
    },
    {
      "code" : "mesh-heading",
      "display" : "MeSH heading",
      "definition" : "MeSH heading"
    },
    {
      "code" : "supplemental-mesh-protocol",
      "display" : "Supplemental MeSH for Protocol",
      "definition" : "Supplemental MeSH for Protocol"
    },
    {
      "code" : "supplemental-mesh-disease",
      "display" : "Supplemental MeSH for Disease",
      "definition" : "Supplemental MeSH for Disease"
    },
    {
      "code" : "supplemental-mesh-organism",
      "display" : "Supplemental MeSH for Organism",
      "definition" : "Supplemental MeSH for Organism"
    },
    {
      "code" : "keyword",
      "display" : "Keyword",
      "definition" : "Keyword"
    },
    {
      "code" : "citation-subset",
      "display" : "Citation subset",
      "definition" : "Citation subset"
    },
    {
      "code" : "chemical",
      "display" : "Chemical",
      "definition" : "Chemical"
    },
    {
      "code" : "publishing-model",
      "display" : "Publishing Model",
      "definition" : "Used for PubModel attribute in Medline"
    },
    {
      "code" : "knowledge-artifact-type",
      "display" : "Knowledge Artifact Type",
      "definition" : "Knowledge Artifact Type"
    },
    {
      "code" : "coverage",
      "display" : "Coverage",
      "definition" : "The spatial or temporal topic of the resource, spatial applicability of the resource, or jurisdiction under which the resource is relevant"
    }
  ]
}

```
