# chromosome-human - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **chromosome-human**

## CodeSystem: chromosome-human 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/chromosome-human | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Chromosome_human |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1086 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Chromosome number for human. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Chromosome_human](ValueSet-chromosome-human.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "chromosome-human",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cg"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/chromosome-human",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1086"
    }
  ],
  "version" : "1.0.0",
  "name" : "Chromosome_human",
  "title" : "chromosome-human",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Chromosome number for human.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/chromosome-human",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "chromosome 1",
      "definition" : "chromosome 1."
    },
    {
      "code" : "2",
      "display" : "chromosome 2",
      "definition" : "chromosome 2."
    },
    {
      "code" : "3",
      "display" : "chromosome 3",
      "definition" : "chromosome 3."
    },
    {
      "code" : "4",
      "display" : "chromosome 4",
      "definition" : "chromosome 4."
    },
    {
      "code" : "5",
      "display" : "chromosome 5",
      "definition" : "chromosome 5."
    },
    {
      "code" : "6",
      "display" : "chromosome 6",
      "definition" : "chromosome 6."
    },
    {
      "code" : "7",
      "display" : "chromosome 7",
      "definition" : "chromosome 7."
    },
    {
      "code" : "8",
      "display" : "chromosome 8",
      "definition" : "chromosome 8."
    },
    {
      "code" : "9",
      "display" : "chromosome 9",
      "definition" : "chromosome 9."
    },
    {
      "code" : "10",
      "display" : "chromosome 10",
      "definition" : "chromosome 10."
    },
    {
      "code" : "11",
      "display" : "chromosome 11",
      "definition" : "chromosome 11."
    },
    {
      "code" : "12",
      "display" : "chromosome 12",
      "definition" : "chromosome 12."
    },
    {
      "code" : "13",
      "display" : "chromosome 13",
      "definition" : "chromosome 13."
    },
    {
      "code" : "14",
      "display" : "chromosome 14",
      "definition" : "chromosome 14."
    },
    {
      "code" : "15",
      "display" : "chromosome 15",
      "definition" : "chromosome 15."
    },
    {
      "code" : "16",
      "display" : "chromosome 16",
      "definition" : "chromosome 16."
    },
    {
      "code" : "17",
      "display" : "chromosome 17",
      "definition" : "chromosome 17."
    },
    {
      "code" : "18",
      "display" : "chromosome 18",
      "definition" : "chromosome 18."
    },
    {
      "code" : "19",
      "display" : "chromosome 19",
      "definition" : "chromosome 19."
    },
    {
      "code" : "20",
      "display" : "chromosome 20",
      "definition" : "chromosome 20."
    },
    {
      "code" : "21",
      "display" : "chromosome 21",
      "definition" : "chromosome 21."
    },
    {
      "code" : "22",
      "display" : "chromosome 22",
      "definition" : "chromosome 22."
    },
    {
      "code" : "X",
      "display" : "chromosome X",
      "definition" : "chromosome X."
    },
    {
      "code" : "Y",
      "display" : "chromosome Y",
      "definition" : "chromosome Y."
    }
  ]
}

```
