# ChoiceListOrientation - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ChoiceListOrientation**

## CodeSystem: ChoiceListOrientation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/choice-list-orientation | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ChoiceListOrientation |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1273 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Direction in which lists of possible answers should be displayed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ChoiceListOrientation](ValueSet-choice-list-orientation.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "choice-list-orientation",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/choice-list-orientation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1273"
    }
  ],
  "version" : "1.0.0",
  "name" : "ChoiceListOrientation",
  "title" : "ChoiceListOrientation",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Direction in which lists of possible answers should be displayed.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/choice-list-orientation",
  "content" : "complete",
  "concept" : [
    {
      "code" : "horizontal",
      "display" : "Horizontal",
      "definition" : "List choices along the horizontal axis."
    },
    {
      "code" : "vertical",
      "display" : "Vertical",
      "definition" : "List choices down the vertical axis."
    }
  ]
}

```
