# Audit Event ID - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Audit Event ID**

## CodeSystem: Audit Event ID 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/audit-event-type | *Version*:1.0.0 | | |
| Active as of 2015-03-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AuditEventID |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1136 | | | |
| **Copyright/Legal**: These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association. | | | |

 
Event Types for Audit Events - defined by DICOM with some FHIR specific additions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "audit-event-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sec"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/audit-event-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1136"
    }
  ],
  "version" : "1.0.0",
  "name" : "AuditEventID",
  "title" : "Audit Event ID",
  "status" : "active",
  "experimental" : false,
  "date" : "2015-03-26T11:00:00+11:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Event Types for Audit Events - defined by DICOM with some FHIR specific additions.",
  "copyright" : "These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "rest",
      "display" : "RESTful Operation",
      "definition" : "Audit Event: Execution of a RESTful operation as defined by FHIR."
    },
    {
      "code" : "hl7-v2",
      "display" : "HL7 v2 Operation",
      "definition" : "Audit Event: Execution of an HL7 v2 operation."
    },
    {
      "code" : "hl7-v3",
      "display" : "HL7 v3 Operation",
      "definition" : "Audit Event: Execution of an HL7 v3 operation as defined by FHIR."
    },
    {
      "code" : "document",
      "display" : "A Document Operation",
      "definition" : "Audit Event: Execution of an operation on a Document (e.g. XDS, CDA, etc)."
    },
    {
      "code" : "object",
      "display" : "An Operation on other Objects",
      "definition" : "Audit Event: Execution of an operation on an Object. For use when a more specific event type is not available."
    }
  ]
}

```
