# Artifact Url Classifier - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Artifact Url Classifier**

## CodeSystem: Artifact Url Classifier 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/artifact-url-classifier | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ArtifactUrlClassifier |

 
Code the reason for different URLs, eg abstract and full-text. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ArtifactUrlClassifier](ValueSet-artifact-url-classifier.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "artifact-url-classifier",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/artifact-url-classifier",
  "version" : "1.0.0",
  "name" : "ArtifactUrlClassifier",
  "title" : "Artifact Url Classifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code the reason for different URLs, eg abstract and full-text.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/artifact-url-classifier",
  "content" : "complete",
  "concept" : [
    {
      "code" : "abstract",
      "display" : "Abstract",
      "definition" : "The URL will reach a brief summary for the article."
    },
    {
      "code" : "full-text",
      "display" : "Full-Text",
      "definition" : "The URL will reach the full-text of the article."
    },
    {
      "code" : "supplement",
      "display" : "Supplement",
      "definition" : "The URL will reach a supplement, appendix, or additional supporting information for the article."
    },
    {
      "code" : "webpage",
      "display" : "Webpage",
      "definition" : "The URL will reach a webpage related to the article, where the content is not easily classified as abstract, full-text or supplement."
    },
    {
      "code" : "file-directory",
      "display" : "File directory",
      "definition" : "The URL will reach a file directory."
    },
    {
      "code" : "code-repository",
      "display" : "Code repository",
      "definition" : "File archive and web hosting facility for source code of software, documentation, web pages, and other works."
    },
    {
      "code" : "restricted",
      "display" : "Restricted",
      "definition" : "The URL content has restricted access (e.g. subcription required)."
    },
    {
      "code" : "compressed-file",
      "display" : "Compressed file",
      "definition" : "Compressed archive file (e.g. a zip file) that contains multiple files"
    },
    {
      "code" : "doi-based",
      "display" : "DOI Based",
      "definition" : "The URL is derived from the Digital Object Identifier (DOI)."
    },
    {
      "code" : "pdf",
      "display" : "PDF",
      "definition" : "The URL will reach content in PDF form."
    },
    {
      "code" : "json",
      "display" : "JSON",
      "definition" : "The URL will reach content in JSON format."
    },
    {
      "code" : "xml",
      "display" : "XML",
      "definition" : "The URL will reach content in XML format."
    },
    {
      "code" : "version-specific",
      "display" : "Version Specific",
      "definition" : "The URL will reach content that is a specific version of the article."
    },
    {
      "code" : "computable-resource",
      "display" : "Computable resource",
      "definition" : "The URL will reach content that is machine-interpretable."
    },
    {
      "code" : "not-specified",
      "display" : "Not Specified",
      "definition" : "Used when URL classifier is not specified but expected in a system."
    }
  ]
}

```
