# External Identifier Systems - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* **External Identifier Systems**

## External Identifier Systems

 Identifier Systems that are defined here are for the convenience of HL7 implementers. These resources serve the special purpose of capturing for easy access descriptive metadata information about each system of identifiers registered here. 

 The systems here are typically used in data types supporting identifier systems, often called namespaces. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [AlabamaDLN](NamingSystem-AlabamaDLN.md)
  * Name: Alabama Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Alabama Motor Vehicle Bureau
* Identity: [AlaskaDLN](NamingSystem-AlaskaDLN.md)
  * Name: Alaska Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Alaska Motor Vehicle Bureau
* Identity: [ArizonaDLN](NamingSystem-ArizonaDLN.md)
  * Name: Arizona Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Arizona Motor Vehicle Bureau
* Identity: [ArkansasDLN](NamingSystem-ArkansasDLN.md)
  * Name: Arkansas Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Arkansas Motor Vehicle Bureau
* Identity: [CCN](NamingSystem-CCN.md)
  * Name: CMS Certification Numbers
  * Version: 1.0.0
  * Status: active
  * Owner: CMS
  * Copyright: n/a
  * Date: 2021-11-01
  * Description: Per CMS Transmittal 29 dated OCTOBER 12, 2007:"The National Provider Identifier (NPI) will repl…
* Identity: [CLIA](NamingSystem-CLIA.md)
  * Name: Clinical Laboratory Improvement Amendments
  * Version: 1.0.0
  * Status: active
  * Owner: [CMS](https://www.cms.gov/)
  * Copyright: n/a
  * Date: 2022-08-25
  * Description: "The Centers for Medicare & Medicaid Services (CMS) regulates all laboratory testing (except resear…
* Identity: [CaliforniaDLN](NamingSystem-CaliforniaDLN.md)
  * Name: California Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: California Motor Vehicle Bureau
* Identity: [ColoradoDLN](NamingSystem-ColoradoDLN.md)
  * Name: Colorado Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Colorado Motor Vehicle Bureau
* Identity: [ConnecticutDLN](NamingSystem-ConnecticutDLN.md)
  * Name: Connecticut Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Connecticut Motor Vehicle Bureau
* Identity: [DCDLN](NamingSystem-DCDLN.md)
  * Name: DC Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: DC Motor Vehicle Bureau
* Identity: [DUNSNumber](NamingSystem-DUNSNumber.md)
  * Name: Data Universal Numbering System (DUNS) Number
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://www.dnb.com/)
  * Copyright: other
  * Date: 2024-10-21
  * Description: "The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit u…
* Identity: [DelawareDLN](NamingSystem-DelawareDLN.md)
  * Name: Delaware Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Delaware Motor Vehicle Bureau
* Identity: [FEI](NamingSystem-FEI.md)
  * Name: FDA Establishment Identifier
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://www.fda.gov/)
  * Copyright: other
  * Date: 2024-10-21
  * Description: "A FDA Establishment Identifier or Firm Establishment Identifier (FEI) is an FDA system generated n…
* Identity: [FOI](NamingSystem-FOI.md)
  * Name: FEvIR Object Identifier
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://computablepublishing.com)
  * Copyright: other
  * Date: 2025-08-07
  * Description: The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Res…
* Identity: [FloridaDLN](NamingSystem-FloridaDLN.md)
  * Name: Florida Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Florida Motor Vehicle Bureau
* Identity: [GLN](NamingSystem-GLN.md)
  * Name: Global Location Number (GLN)
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://www.gs1.org/gs1-global-office)
  * Copyright: n/a
  * Date: 2021-12-02
  * Description: Global Location Number (GLN) can be used by companies to identify their locations, giving them comp…
* Identity: [GeorgiaDLN](NamingSystem-GeorgiaDLN.md)
  * Name: Georgia Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Georgia Motor Vehicle Bureau
* Identity: [HawaiiDLN](NamingSystem-HawaiiDLN.md)
  * Name: Hawaii Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Hawaii Motor Vehicle Bureau
* Identity: [IdahoDLN](NamingSystem-IdahoDLN.md)
  * Name: Idaho Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Idaho Motor Vehicle Bureau
* Identity: [IllinoisDLN](NamingSystem-IllinoisDLN.md)
  * Name: Illinois Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Illinois Motor Vehicle Bureau
* Identity: [IndianaDLN](NamingSystem-IndianaDLN.md)
  * Name: Indiana Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Indiana Motor Vehicle Bureau
* Identity: [IowaDLN](NamingSystem-IowaDLN.md)
  * Name: Iowa Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Iowa Motor Vehicle Bureau
* Identity: [KansasDLN](NamingSystem-KansasDLN.md)
  * Name: Kansas Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Kansas Motor Vehicle Bureau
* Identity: [KentuckyDLN](NamingSystem-KentuckyDLN.md)
  * Name: Kentucky Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Kentucky Motor Vehicle Bureau
* Identity: [LouisianaDLN](NamingSystem-LouisianaDLN.md)
  * Name: Louisiana Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Louisiana Motor Vehicle Bureau
* Identity: [MaineDLN](NamingSystem-MaineDLN.md)
  * Name: Maine Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Maine Motor Vehicle Bureau
* Identity: [MarylandDLN](NamingSystem-MarylandDLN.md)
  * Name: Maryland Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Maryland Motor Vehicle Bureau
* Identity: [MassachusettsDLN](NamingSystem-MassachusettsDLN.md)
  * Name: Massachusetts Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Massachusetts Motor Vehicle Bureau
* Identity: [MichiganDLN](NamingSystem-MichiganDLN.md)
  * Name: Michigan Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Michigan Motor Vehicle Bureau
* Identity: [MinnesotaDLN](NamingSystem-MinnesotaDLN.md)
  * Name: Minnesota Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Minnesota Motor Vehicle Bureau
* Identity: [MississippiDLN](NamingSystem-MississippiDLN.md)
  * Name: Mississippi Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Mississippi Motor Vehicle Bureau
* Identity: [MissouriDLN](NamingSystem-MissouriDLN.md)
  * Name: Missouri Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Missouri Motor Vehicle Bureau
* Identity: [MontanaDLN](NamingSystem-MontanaDLN.md)
  * Name: Montana Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Montana Motor Vehicle Bureau
* Identity: [NAICCompanyCodes](NamingSystem-NAICCompanyCodes.md)
  * Name: National Association of Insurance Commissioners (NAIC) Company Codes
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://content.naic.org/)
  * Copyright: other
  * Date: 2025-05-05
  * Description: NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned …
* Identity: [NebraskaDLN](NamingSystem-NebraskaDLN.md)
  * Name: Nebraska Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Nebraska Motor Vehicle Bureau
* Identity: [NevadaDLN](NamingSystem-NevadaDLN.md)
  * Name: Nevada Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Nevada Motor Vehicle Bureau
* Identity: [NewHampshireDLN](NamingSystem-NewHampshireDLN.md)
  * Name: New Hampshire Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: New Hampshire Motor Vehicle Bureau
* Identity: [NewJerseyDLN](NamingSystem-NewJerseyDLN.md)
  * Name: New Jersey Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: New Jersey Motor Vehicle Bureau
* Identity: [NewMexicoDLN](NamingSystem-NewMexicoDLN.md)
  * Name: NewMexico Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: New Mexico Motor Vehicle Bureau
* Identity: [NewYorkDLN](NamingSystem-NewYorkDLN.md)
  * Name: New York Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: New York Motor Vehicle Bureau
* Identity: [NorthCarolinaDLN](NamingSystem-NorthCarolinaDLN.md)
  * Name: North Carolina Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: North Carolina Motor Vehicle Bureau
* Identity: [NorthDakotaDLN](NamingSystem-NorthDakotaDLN.md)
  * Name: North Dakota Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: North Dakota Motor Vehicle Bureau
* Identity: [OhioDLN](NamingSystem-OhioDLN.md)
  * Name: Ohio Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Ohio Motor Vehicle Bureau
* Identity: [OklahomaDLN](NamingSystem-OklahomaDLN.md)
  * Name: Oklahoma Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Oklahoma Motor Vehicle Bureau
* Identity: [OregonDLN](NamingSystem-OregonDLN.md)
  * Name: Oregon Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Oregon Motor Vehicle Bureau
* Identity: [PennsylvaniaDLN](NamingSystem-PennsylvaniaDLN.md)
  * Name: Pennsylvania Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Pennsylvania Motor Vehicle Bureau
* Identity: [RhodeIslandDLN](NamingSystem-RhodeIslandDLN.md)
  * Name: Rhode Island Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Rhode Island Motor Vehicle Bureau
* Identity: [SouthCarolinaDLN](NamingSystem-SouthCarolinaDLN.md)
  * Name: South Carolina Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: South Carolina Motor Vehicle Bureau
* Identity: [SouthDakotaDLN](NamingSystem-SouthDakotaDLN.md)
  * Name: South Dakota Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: South Dakota Motor Vehicle Bureau
* Identity: [TennesseeDLN](NamingSystem-TennesseeDLN.md)
  * Name: Tennessee Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Tennessee Motor Vehicle Bureau
* Identity: [TexasDLN](NamingSystem-TexasDLN.md)
  * Name: Texas Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Texas Motor Vehicle Bureau
* Identity: [USDEANumber](NamingSystem-USDEANumber.md)
  * Name: United States Drug Enforcement Agency (DEA) Number
  * Version: 1.0.0
  * Status: active
  * Owner: [n/a](https://www.deadiversion.usdoj.gov/index.html)
  * Copyright: n/a
  * Date: 2024-06-03
  * Description: A DEA number is a number assigned to a health care provider (such as a medical practitioner, dent…
* Identity: [USEIN](NamingSystem-USEIN.md)
  * Name: United States Employer Identification Number
  * Version: 1.0.0
  * Status: active
  * Owner: [n/a](https://www.irs.gov/businesses/small-businesses-self-employed/employer-id-numbers)
  * Copyright: n/a
  * Date: 2022-06-13
  * Description: An Employer Identification Number (EIN) is also known as a Federal Tax Identification Number, and i…
* Identity: [UniProt](NamingSystem-UniProt.md)
  * Name: Universal Protein Resource
  * Version: 1.0.0
  * Status: active
  * Owner: [external](https://www.uniprot.org/contact)
  * Copyright: other
  * Date: 2025-03-24
  * Description: The Universal Protein Resource (UniProt) is a comprehensive resource for protein sequence and annot…
* Identity: [UtahDLN](NamingSystem-UtahDLN.md)
  * Name: Utah Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Utah Motor Vehicle Bureau
* Identity: [VermontDLN](NamingSystem-VermontDLN.md)
  * Name: Vermont Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Vermont Motor Vehicle Bureau
* Identity: [VirginiaDLN](NamingSystem-VirginiaDLN.md)
  * Name: Virginia Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Virginia Motor Vehicle Bureau
* Identity: [WashingtonDLN](NamingSystem-WashingtonDLN.md)
  * Name: Washington Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Washington Motor Vehicle Bureau
* Identity: [WestVirginiaDLN](NamingSystem-WestVirginiaDLN.md)
  * Name: West Virginia Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: West Virginia Motor Vehicle Bureau
* Identity: [WisconsinDLN](NamingSystem-WisconsinDLN.md)
  * Name: Wisconsin Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Wisconsin Motor Vehicle Bureau
* Identity: [WyomingDLN](NamingSystem-WyomingDLN.md)
  * Name: Wyoming Driver's License
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Wyoming Motor Vehicle Bureau
* Identity: [bluetooth-address-i…](NamingSystem-bluetooth-address-identifier.md)
  * Name: Bluetooth Address as a device identifier
  * Version: 1.0.0
  * Status: active
  * Owner: external
  * Copyright: n/a
  * Date: 2021-06-14
  * Description: The Bluetooth Device Address (sometimes referred to as a Bluetooth MAC address) is a unique 48-bit …
* Identity: [cmsMBI](NamingSystem-cmsMBI.md)
  * Name: Medicare Beneficiary Identifier (United States)
  * Version: 1.0.0
  * Status: active
  * Owner: CMS
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Medicare Beneficiary Identifier (MBI) number is a unique identifier of a beneficiary used for Medic…
* Identity: [dui](NamingSystem-dui.md)
  * Name: DICOM Unique Id
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of "ur…
* Identity: [ethernet-address-id…](NamingSystem-ethernet-address-identifier.md)
  * Name: Ethernet MAC Address as a device identifier
  * Version: 2.1.0
  * Status: active
  * Owner: external
  * Copyright: n/a
  * Date: 2021-06-14
  * Description: The Ethernet MAC (media access control) address is a unique identifier assigned to a network interf…
* Identity: [gtin](NamingSystem-gtin.md)
  * Name: GTIN Global Trade Item Number
  * Version: 3.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or s…
* Identity: [imei-identifier](NamingSystem-imei-identifier.md)
  * Name: IMEI as a device identifier
  * Version: 1.0.0
  * Status: active
  * Owner: external
  * Copyright: n/a
  * Date: 2021-06-14
  * Description: The International Mobile Equipment Identity (IMEI) is a number, usually unique, to identify 3GPP an…
* Identity: [medicareHIC](NamingSystem-medicareHIC.md)
  * Name: United States Medicare Number
  * Version: 1.0.0
  * Status: active
  * Owner: CMS
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Medicare Health Insurance Claim # (HIC) is a unique identifier of a beneficiary used for Medicare e…
* Identity: [npi](NamingSystem-npi.md)
  * Name: United States National Provider Identifier
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: National Provider Identifier
* Identity: [passportNumNS-ABW](NamingSystem-passportNumNS-ABW.md)
  * Name: Passport Numbers Namespace for ARUBA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ARUBA. Used for the HL7 …
* Identity: [passportNumNS-AFG](NamingSystem-passportNumNS-AFG.md)
  * Name: Passport Numbers Namespace for AFGHANISTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of AFGHANISTAN. Used for th…
* Identity: [passportNumNS-AGO](NamingSystem-passportNumNS-AGO.md)
  * Name: Passport Numbers Namespace for ANGOLA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ANGOLA. Used for the HL7…
* Identity: [passportNumNS-AIA](NamingSystem-passportNumNS-AIA.md)
  * Name: Passport Numbers Namespace for ANGUILLA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ANGUILLA. Used for the H…
* Identity: [passportNumNS-ALA](NamingSystem-passportNumNS-ALA.md)
  * Name: Passport Numbers Namespace for ALAND ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ALAND ISLANDS. Used for …
* Identity: [passportNumNS-ALB](NamingSystem-passportNumNS-ALB.md)
  * Name: Passport Numbers Namespace for ALBANIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ALBANIA. Used for the HL…
* Identity: [passportNumNS-AND](NamingSystem-passportNumNS-AND.md)
  * Name: Passport Numbers Namespace for ANDORRA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ANDORRA. Used for the HL…
* Identity: [passportNumNS-ANT](NamingSystem-passportNumNS-ANT.md)
  * Name: Passport Numbers Namespace for NETHERLANDS ANTILLES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS ANTILLES. Us…
* Identity: [passportNumNS-ARE](NamingSystem-passportNumNS-ARE.md)
  * Name: Passport Numbers Namespace for UNITED ARAB EMIRATES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UNITED ARAB EMIRATES. Us…
* Identity: [passportNumNS-ARG](NamingSystem-passportNumNS-ARG.md)
  * Name: Passport Numbers Namespace for ARGENTINA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ARGENTINA. Used for the …
* Identity: [passportNumNS-ARM](NamingSystem-passportNumNS-ARM.md)
  * Name: Passport Numbers Namespace for ARMENIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ARMENIA. Used for the HL…
* Identity: [passportNumNS-ASM](NamingSystem-passportNumNS-ASM.md)
  * Name: Passport Numbers Namespace for AMERICAN SAMOA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of AMERICAN SAMOA. Used for…
* Identity: [passportNumNS-ATA](NamingSystem-passportNumNS-ATA.md)
  * Name: Passport Numbers Namespace for ANTARCTICA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ANTARCTICA. Used for the…
* Identity: [passportNumNS-ATF](NamingSystem-passportNumNS-ATF.md)
  * Name: Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORI…
* Identity: [passportNumNS-ATG](NamingSystem-passportNumNS-ATG.md)
  * Name: Passport Numbers Namespace for ANTIGUA AND BARBUDA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ANTIGUA AND BARBUDA. Use…
* Identity: [passportNumNS-AUS](NamingSystem-passportNumNS-AUS.md)
  * Name: Passport Numbers Namespace for AUSTRALIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of AUSTRALIA. Used for the …
* Identity: [passportNumNS-AUT](NamingSystem-passportNumNS-AUT.md)
  * Name: Passport Numbers Namespace for AUSTRIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of AUSTRIA. Used for the HL…
* Identity: [passportNumNS-AZE](NamingSystem-passportNumNS-AZE.md)
  * Name: Passport Numbers Namespace for AZERBAIJAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of AZERBAIJAN. Used for the…
* Identity: [passportNumNS-BDI](NamingSystem-passportNumNS-BDI.md)
  * Name: Passport Numbers Namespace for BURUNDI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BURUNDI. Used for the HL…
* Identity: [passportNumNS-BEL](NamingSystem-passportNumNS-BEL.md)
  * Name: Passport Numbers Namespace for BELGIUM
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BELGIUM. Used for the HL…
* Identity: [passportNumNS-BEN](NamingSystem-passportNumNS-BEN.md)
  * Name: Passport Numbers Namespace for BENIN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BENIN. Used for the HL7 …
* Identity: [passportNumNS-BFA](NamingSystem-passportNumNS-BFA.md)
  * Name: Passport Numbers Namespace for BURKINA FASO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BURKINA FASO. Used for t…
* Identity: [passportNumNS-BGD](NamingSystem-passportNumNS-BGD.md)
  * Name: Passport Numbers Namespace for BANGLADESH
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BANGLADESH. Used for the…
* Identity: [passportNumNS-BGR](NamingSystem-passportNumNS-BGR.md)
  * Name: Passport Numbers Namespace for BULGARIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BULGARIA. Used for the H…
* Identity: [passportNumNS-BHR](NamingSystem-passportNumNS-BHR.md)
  * Name: Passport Numbers Namespace for BAHRAIN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BAHRAIN. Used for the HL…
* Identity: [passportNumNS-BHS](NamingSystem-passportNumNS-BHS.md)
  * Name: Passport Numbers Namespace for BAHAMAS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BAHAMAS. Used for the HL…
* Identity: [passportNumNS-BIH](NamingSystem-passportNumNS-BIH.md)
  * Name: Passport Numbers Namespace for BOSNIA AND HERZEGOVINA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BOSNIA AND HERZEGOVINA. …
* Identity: [passportNumNS-BLM](NamingSystem-passportNumNS-BLM.md)
  * Name: Passport Numbers Namespace for SAINT BARTHELEMY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT BARTHELEMY. Used f…
* Identity: [passportNumNS-BLR](NamingSystem-passportNumNS-BLR.md)
  * Name: Passport Numbers Namespace for BELARUS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BELARUS. Used for the HL…
* Identity: [passportNumNS-BLZ](NamingSystem-passportNumNS-BLZ.md)
  * Name: Passport Numbers Namespace for BELIZE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BELIZE. Used for the HL7…
* Identity: [passportNumNS-BMU](NamingSystem-passportNumNS-BMU.md)
  * Name: Passport Numbers Namespace for BERMUDA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BERMUDA. Used for the HL…
* Identity: [passportNumNS-BOL](NamingSystem-passportNumNS-BOL.md)
  * Name: Passport Numbers Namespace for BOLIVIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BOLIVIA. Used for the HL…
* Identity: [passportNumNS-BRA](NamingSystem-passportNumNS-BRA.md)
  * Name: Passport Numbers Namespace for BRAZIL
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BRAZIL. Used for the HL7…
* Identity: [passportNumNS-BRB](NamingSystem-passportNumNS-BRB.md)
  * Name: Passport Numbers Namespace for BARBADOS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BARBADOS. Used for the H…
* Identity: [passportNumNS-BRN](NamingSystem-passportNumNS-BRN.md)
  * Name: Passport Numbers Namespace for BRUNEI DARUSSALAM
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BRUNEI DARUSSALAM. Used …
* Identity: [passportNumNS-BTN](NamingSystem-passportNumNS-BTN.md)
  * Name: Passport Numbers Namespace for BHUTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BHUTAN. Used for the HL7…
* Identity: [passportNumNS-BVT](NamingSystem-passportNumNS-BVT.md)
  * Name: Passport Numbers Namespace for BOUVET ISLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BOUVET ISLAND. Used for …
* Identity: [passportNumNS-BWA](NamingSystem-passportNumNS-BWA.md)
  * Name: Passport Numbers Namespace for BOTSWANA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BOTSWANA. Used for the H…
* Identity: [passportNumNS-CAF](NamingSystem-passportNumNS-CAF.md)
  * Name: Passport Numbers Namespace for CENTRAL AFRICAN REPUBLIC
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CENTRAL AFRICAN REPUBLIC.…
* Identity: [passportNumNS-CAN](NamingSystem-passportNumNS-CAN.md)
  * Name: Passport Numbers Namespace for CANADA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CANADA. Used for the HL7…
* Identity: [passportNumNS-CCK](NamingSystem-passportNumNS-CCK.md)
  * Name: Passport Numbers Namespace for COCOS (KEELING) ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COCOS (KEELING) ISLANDS. …
* Identity: [passportNumNS-CHE](NamingSystem-passportNumNS-CHE.md)
  * Name: Passport Numbers Namespace for SWITZERLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SWITZERLAND. Used for th…
* Identity: [passportNumNS-CHL](NamingSystem-passportNumNS-CHL.md)
  * Name: Passport Numbers Namespace for CHILE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CHILE. Used for the HL7 …
* Identity: [passportNumNS-CHN](NamingSystem-passportNumNS-CHN.md)
  * Name: Passport Numbers Namespace for CHINA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CHINA. Used for the HL7 …
* Identity: [passportNumNS-CIV](NamingSystem-passportNumNS-CIV.md)
  * Name: Passport Numbers Namespace for COTE D'IVOIRE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COTE D'IVOIRE. Used for …
* Identity: [passportNumNS-CMR](NamingSystem-passportNumNS-CMR.md)
  * Name: Passport Numbers Namespace for CAMEROON
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CAMEROON. Used for the H…
* Identity: [passportNumNS-COD](NamingSystem-passportNumNS-COD.md)
  * Name: Passport Numbers Namespace for CONGO, THE DEMOCRATIC REPUBLIC OF THE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CONGO, THE DEMOCRATIC REP…
* Identity: [passportNumNS-COG](NamingSystem-passportNumNS-COG.md)
  * Name: Passport Numbers Namespace for CONGO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CONGO. Used for the HL7 …
* Identity: [passportNumNS-COK](NamingSystem-passportNumNS-COK.md)
  * Name: Passport Numbers Namespace for COOK ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COOK ISLANDS. Used for t…
* Identity: [passportNumNS-COL](NamingSystem-passportNumNS-COL.md)
  * Name: Passport Numbers Namespace for COLOMBIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COLOMBIA. Used for the H…
* Identity: [passportNumNS-COM](NamingSystem-passportNumNS-COM.md)
  * Name: Passport Numbers Namespace for COMOROS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COMOROS. Used for the HL…
* Identity: [passportNumNS-CPV](NamingSystem-passportNumNS-CPV.md)
  * Name: Passport Numbers Namespace for CAPE VERDE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CAPE VERDE. Used for the…
* Identity: [passportNumNS-CRI](NamingSystem-passportNumNS-CRI.md)
  * Name: Passport Numbers Namespace for COSTA RICA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of COSTA RICA. Used for the…
* Identity: [passportNumNS-CUB](NamingSystem-passportNumNS-CUB.md)
  * Name: Passport Numbers Namespace for CUBA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CUBA. Used for the HL7 v…
* Identity: [passportNumNS-CXR](NamingSystem-passportNumNS-CXR.md)
  * Name: Passport Numbers Namespace for CHRISTMAS ISLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CHRISTMAS ISLAND. Used f…
* Identity: [passportNumNS-CYM](NamingSystem-passportNumNS-CYM.md)
  * Name: Passport Numbers Namespace for CAYMAN ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CAYMAN ISLANDS. Used for…
* Identity: [passportNumNS-CYP](NamingSystem-passportNumNS-CYP.md)
  * Name: Passport Numbers Namespace for CYPRUS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CYPRUS. Used for the HL7…
* Identity: [passportNumNS-CZE](NamingSystem-passportNumNS-CZE.md)
  * Name: Passport Numbers Namespace for CZECH REPUBLIC
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC. Used for…
* Identity: [passportNumNS-DEU](NamingSystem-passportNumNS-DEU.md)
  * Name: Passport Numbers Namespace for GERMANY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GERMANY. Used for the HL…
* Identity: [passportNumNS-DJI](NamingSystem-passportNumNS-DJI.md)
  * Name: Passport Numbers Namespace for DJIBOUTI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of DJIBOUTI. Used for the H…
* Identity: [passportNumNS-DMA](NamingSystem-passportNumNS-DMA.md)
  * Name: Passport Numbers Namespace for DOMINICA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of DOMINICA. Used for the H…
* Identity: [passportNumNS-DNK](NamingSystem-passportNumNS-DNK.md)
  * Name: Passport Numbers Namespace for DENMARK
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of DENMARK. Used for the HL…
* Identity: [passportNumNS-DOM](NamingSystem-passportNumNS-DOM.md)
  * Name: Passport Numbers Namespace for DOMINICAN REPUBLIC
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of DOMINICAN REPUBLIC. Used…
* Identity: [passportNumNS-DZA](NamingSystem-passportNumNS-DZA.md)
  * Name: Passport Numbers Namespace for ALGERIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ALGERIA. Used for the HL…
* Identity: [passportNumNS-ECU](NamingSystem-passportNumNS-ECU.md)
  * Name: Passport Numbers Namespace for ECUADOR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ECUADOR. Used for the HL…
* Identity: [passportNumNS-EGY](NamingSystem-passportNumNS-EGY.md)
  * Name: Passport Numbers Namespace for EGYPT
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of EGYPT. Used for the HL7 …
* Identity: [passportNumNS-ERI](NamingSystem-passportNumNS-ERI.md)
  * Name: Passport Numbers Namespace for ERITREA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ERITREA. Used for the HL…
* Identity: [passportNumNS-ESH](NamingSystem-passportNumNS-ESH.md)
  * Name: Passport Numbers Namespace for WESTERN SAHARA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of WESTERN SAHARA. Used for…
* Identity: [passportNumNS-ESP](NamingSystem-passportNumNS-ESP.md)
  * Name: Passport Numbers Namespace for SPAIN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SPAIN. Used for the HL7 …
* Identity: [passportNumNS-EST](NamingSystem-passportNumNS-EST.md)
  * Name: Passport Numbers Namespace for ESTONIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ESTONIA. Used for the HL…
* Identity: [passportNumNS-ETH](NamingSystem-passportNumNS-ETH.md)
  * Name: Passport Numbers Namespace for ETHIOPIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ETHIOPIA. Used for the H…
* Identity: [passportNumNS-FIN](NamingSystem-passportNumNS-FIN.md)
  * Name: Passport Numbers Namespace for FINLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FINLAND. Used for the HL…
* Identity: [passportNumNS-FJI](NamingSystem-passportNumNS-FJI.md)
  * Name: Passport Numbers Namespace for FIJI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FIJI. Used for the HL7 v…
* Identity: [passportNumNS-FLK](NamingSystem-passportNumNS-FLK.md)
  * Name: Passport Numbers Namespace for FALKLAND ISLANDS (MALVINAS)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FALKLAND ISLANDS (MALVINA…
* Identity: [passportNumNS-FRA](NamingSystem-passportNumNS-FRA.md)
  * Name: Passport Numbers Namespace for FRANCE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FRANCE. Used for the HL7…
* Identity: [passportNumNS-FRO](NamingSystem-passportNumNS-FRO.md)
  * Name: Passport Numbers Namespace for FAROE ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FAROE ISLANDS. Used for …
* Identity: [passportNumNS-FSM](NamingSystem-passportNumNS-FSM.md)
  * Name: Passport Numbers Namespace for MICRONESIA, FEDERATED STATES OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MICRONESIA, FEDERATED STA…
* Identity: [passportNumNS-GAB](NamingSystem-passportNumNS-GAB.md)
  * Name: Passport Numbers Namespace for GABON
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GABON. Used for the HL7 …
* Identity: [passportNumNS-GBR](NamingSystem-passportNumNS-GBR.md)
  * Name: Passport Numbers Namespace for UNITED KINGDOM
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UNITED KINGDOM. Used for…
* Identity: [passportNumNS-GEO](NamingSystem-passportNumNS-GEO.md)
  * Name: Passport Numbers Namespace for GEORGIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GEORGIA. Used for the HL…
* Identity: [passportNumNS-GGY](NamingSystem-passportNumNS-GGY.md)
  * Name: Passport Numbers Namespace for GUERNSEY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUERNSEY. Used for the H…
* Identity: [passportNumNS-GHA](NamingSystem-passportNumNS-GHA.md)
  * Name: Passport Numbers Namespace for GHANA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GHANA. Used for the HL7 …
* Identity: [passportNumNS-GIB](NamingSystem-passportNumNS-GIB.md)
  * Name: Passport Numbers Namespace for GIBRALTAR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GIBRALTAR. Used for the …
* Identity: [passportNumNS-GIN](NamingSystem-passportNumNS-GIN.md)
  * Name: Passport Numbers Namespace for GUINEA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUINEA. Used for the HL7…
* Identity: [passportNumNS-GLP](NamingSystem-passportNumNS-GLP.md)
  * Name: Passport Numbers Namespace for GUADELOUPE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUADELOUPE. Used for the…
* Identity: [passportNumNS-GMB](NamingSystem-passportNumNS-GMB.md)
  * Name: Passport Numbers Namespace for GAMBIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GAMBIA. Used for the HL7…
* Identity: [passportNumNS-GNB](NamingSystem-passportNumNS-GNB.md)
  * Name: Passport Numbers Namespace for GUINEA-BISSAU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUINEA-BISSAU. Used for …
* Identity: [passportNumNS-GNQ](NamingSystem-passportNumNS-GNQ.md)
  * Name: Passport Numbers Namespace for EQUATORIAL GUINEA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of EQUATORIAL GUINEA. Used …
* Identity: [passportNumNS-GRC](NamingSystem-passportNumNS-GRC.md)
  * Name: Passport Numbers Namespace for GREECE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GREECE. Used for the HL7…
* Identity: [passportNumNS-GRD](NamingSystem-passportNumNS-GRD.md)
  * Name: Passport Numbers Namespace for GRENADA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GRENADA. Used for the HL…
* Identity: [passportNumNS-GRL](NamingSystem-passportNumNS-GRL.md)
  * Name: Passport Numbers Namespace for GREENLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GREENLAND. Used for the …
* Identity: [passportNumNS-GTM](NamingSystem-passportNumNS-GTM.md)
  * Name: Passport Numbers Namespace for GUATEMALA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUATEMALA. Used for the …
* Identity: [passportNumNS-GUF](NamingSystem-passportNumNS-GUF.md)
  * Name: Passport Numbers Namespace for FRENCH GUIANA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FRENCH GUIANA. Used for …
* Identity: [passportNumNS-GUM](NamingSystem-passportNumNS-GUM.md)
  * Name: Passport Numbers Namespace for GUAM
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUAM. Used for the HL7 v…
* Identity: [passportNumNS-GUY](NamingSystem-passportNumNS-GUY.md)
  * Name: Passport Numbers Namespace for GUYANA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of GUYANA. Used for the HL7…
* Identity: [passportNumNS-HKG](NamingSystem-passportNumNS-HKG.md)
  * Name: Passport Numbers Namespace for HONG KONG
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HONG KONG. Used for the …
* Identity: [passportNumNS-HMD](NamingSystem-passportNumNS-HMD.md)
  * Name: Passport Numbers Namespace for HEARD ISLAND AND MCDONALD ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HEARD ISLAND AND MCDONALD…
* Identity: [passportNumNS-HND](NamingSystem-passportNumNS-HND.md)
  * Name: Passport Numbers Namespace for HONDURAS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HONDURAS. Used for the H…
* Identity: [passportNumNS-HRV](NamingSystem-passportNumNS-HRV.md)
  * Name: Passport Numbers Namespace for CROATIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CROATIA. Used for the HL…
* Identity: [passportNumNS-HTI](NamingSystem-passportNumNS-HTI.md)
  * Name: Passport Numbers Namespace for HAITI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HAITI. Used for the HL7 …
* Identity: [passportNumNS-HUN](NamingSystem-passportNumNS-HUN.md)
  * Name: Passport Numbers Namespace for HUNGARY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HUNGARY. Used for the HL…
* Identity: [passportNumNS-IDN](NamingSystem-passportNumNS-IDN.md)
  * Name: Passport Numbers Namespace for INDONESIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of INDONESIA. Used for the …
* Identity: [passportNumNS-IMM](NamingSystem-passportNumNS-IMM.md)
  * Name: Passport Numbers Namespace for ISLE OF MAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ISLE OF MAN. Used for th…
* Identity: [passportNumNS-IND](NamingSystem-passportNumNS-IND.md)
  * Name: Passport Numbers Namespace for INDIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of INDIA. Used for the HL7 …
* Identity: [passportNumNS-IOT](NamingSystem-passportNumNS-IOT.md)
  * Name: Passport Numbers Namespace for BRITISH INDIAN OCEAN TERRITORY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of BRITISH INDIAN OCEAN TERR…
* Identity: [passportNumNS-IRL](NamingSystem-passportNumNS-IRL.md)
  * Name: Passport Numbers Namespace for IRELAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of IRELAND. Used for the HL…
* Identity: [passportNumNS-IRN](NamingSystem-passportNumNS-IRN.md)
  * Name: Passport Numbers Namespace for IRAN (ISLAMIC REPUBLIC OF)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of IRAN (ISLAMIC REPUBLIC OF…
* Identity: [passportNumNS-IRQ](NamingSystem-passportNumNS-IRQ.md)
  * Name: Passport Numbers Namespace for IRAQ
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of IRAQ. Used for the HL7 v…
* Identity: [passportNumNS-ISL](NamingSystem-passportNumNS-ISL.md)
  * Name: Passport Numbers Namespace for ICELAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ICELAND. Used for the HL…
* Identity: [passportNumNS-ISR](NamingSystem-passportNumNS-ISR.md)
  * Name: Passport Numbers Namespace for ISRAEL
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ISRAEL. Used for the HL7…
* Identity: [passportNumNS-ITA](NamingSystem-passportNumNS-ITA.md)
  * Name: Passport Numbers Namespace for ITALY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ITALY. Used for the HL7 …
* Identity: [passportNumNS-JAM](NamingSystem-passportNumNS-JAM.md)
  * Name: Passport Numbers Namespace for JAMAICA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of JAMAICA. Used for the HL…
* Identity: [passportNumNS-JEY](NamingSystem-passportNumNS-JEY.md)
  * Name: Passport Numbers Namespace for JERSEY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of JERSEY. Used for the HL7…
* Identity: [passportNumNS-JOR](NamingSystem-passportNumNS-JOR.md)
  * Name: Passport Numbers Namespace for JORDAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of JORDAN. Used for the HL7…
* Identity: [passportNumNS-JPN](NamingSystem-passportNumNS-JPN.md)
  * Name: Passport Numbers Namespace for JAPAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of JAPAN. Used for the HL7 …
* Identity: [passportNumNS-KAZ](NamingSystem-passportNumNS-KAZ.md)
  * Name: Passport Numbers Namespace for KAZAKHSTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KAZAKHSTAN. Used for the…
* Identity: [passportNumNS-KEN](NamingSystem-passportNumNS-KEN.md)
  * Name: Passport Numbers Namespace for KENYA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KENYA. Used for the HL7 …
* Identity: [passportNumNS-KGZ](NamingSystem-passportNumNS-KGZ.md)
  * Name: Passport Numbers Namespace for KYRGYZSTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KYRGYZSTAN. Used for the…
* Identity: [passportNumNS-KHM](NamingSystem-passportNumNS-KHM.md)
  * Name: Passport Numbers Namespace for CAMBODIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA. Used for the H…
* Identity: [passportNumNS-KIR](NamingSystem-passportNumNS-KIR.md)
  * Name: Passport Numbers Namespace for KIRIBATI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KIRIBATI. Used for the H…
* Identity: [passportNumNS-KNA](NamingSystem-passportNumNS-KNA.md)
  * Name: Passport Numbers Namespace for SAINT KITTS AND NEVIS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT KITTS AND NEVIS. U…
* Identity: [passportNumNS-KOR](NamingSystem-passportNumNS-KOR.md)
  * Name: Passport Numbers Namespace for KOREA, REPUBLIC OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KOREA, REPUBLIC OF. Used…
* Identity: [passportNumNS-KWT](NamingSystem-passportNumNS-KWT.md)
  * Name: Passport Numbers Namespace for KUWAIT
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KUWAIT. Used for the HL7…
* Identity: [passportNumNS-LAO](NamingSystem-passportNumNS-LAO.md)
  * Name: Passport Numbers Namespace for LAO PEOPLE'S DEMOCRATIC REPUBLIC
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LAO PEOPLE'S DEMOCRATIC R…
* Identity: [passportNumNS-LBN](NamingSystem-passportNumNS-LBN.md)
  * Name: Passport Numbers Namespace for LEBANON
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LEBANON. Used for the HL…
* Identity: [passportNumNS-LBR](NamingSystem-passportNumNS-LBR.md)
  * Name: Passport Numbers Namespace for LIBERIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LIBERIA. Used for the HL…
* Identity: [passportNumNS-LBY](NamingSystem-passportNumNS-LBY.md)
  * Name: Passport Numbers Namespace for LIBYAN ARAB JAMAHIRIYA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LIBYAN ARAB JAMAHIRIYA. …
* Identity: [passportNumNS-LCA](NamingSystem-passportNumNS-LCA.md)
  * Name: Passport Numbers Namespace for SAINT LUCIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT LUCIA. Used for th…
* Identity: [passportNumNS-LIE](NamingSystem-passportNumNS-LIE.md)
  * Name: Passport Numbers Namespace for LIECHTENSTEIN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LIECHTENSTEIN. Used for …
* Identity: [passportNumNS-LKA](NamingSystem-passportNumNS-LKA.md)
  * Name: Passport Numbers Namespace for SRI LANKA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SRI LANKA. Used for the …
* Identity: [passportNumNS-LSO](NamingSystem-passportNumNS-LSO.md)
  * Name: Passport Numbers Namespace for LESOTHO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LESOTHO. Used for the HL…
* Identity: [passportNumNS-LTU](NamingSystem-passportNumNS-LTU.md)
  * Name: Passport Numbers Namespace for LITHUANIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LITHUANIA. Used for the …
* Identity: [passportNumNS-LUX](NamingSystem-passportNumNS-LUX.md)
  * Name: Passport Numbers Namespace for LUXEMBOURG
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG. Used for the…
* Identity: [passportNumNS-LVA](NamingSystem-passportNumNS-LVA.md)
  * Name: Passport Numbers Namespace for LATVIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of LATVIA. Used for the HL7…
* Identity: [passportNumNS-MAC](NamingSystem-passportNumNS-MAC.md)
  * Name: Passport Numbers Namespace for MACAO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MACAO. Used for the HL7 …
* Identity: [passportNumNS-MAF](NamingSystem-passportNumNS-MAF.md)
  * Name: Passport Numbers Namespace for SAINT MARTIN (FRENCH PART)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT MARTIN (FRENCH PART…
* Identity: [passportNumNS-MAR](NamingSystem-passportNumNS-MAR.md)
  * Name: Passport Numbers Namespace for MOROCCO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MOROCCO. Used for the HL…
* Identity: [passportNumNS-MCO](NamingSystem-passportNumNS-MCO.md)
  * Name: Passport Numbers Namespace for MONACO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MONACO. Used for the HL7…
* Identity: [passportNumNS-MDA](NamingSystem-passportNumNS-MDA.md)
  * Name: Passport Numbers Namespace for MOLDOVA, REPUBLIC OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MOLDOVA, REPUBLIC OF. Us…
* Identity: [passportNumNS-MDG](NamingSystem-passportNumNS-MDG.md)
  * Name: Passport Numbers Namespace for MADAGASCAR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MADAGASCAR. Used for the…
* Identity: [passportNumNS-MDV](NamingSystem-passportNumNS-MDV.md)
  * Name: Passport Numbers Namespace for MALDIVES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MALDIVES. Used for the H…
* Identity: [passportNumNS-MEX](NamingSystem-passportNumNS-MEX.md)
  * Name: Passport Numbers Namespace for MEXICO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MEXICO. Used for the HL7…
* Identity: [passportNumNS-MHL](NamingSystem-passportNumNS-MHL.md)
  * Name: Passport Numbers Namespace for MARSHALL ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MARSHALL ISLANDS. Used f…
* Identity: [passportNumNS-MKD](NamingSystem-passportNumNS-MKD.md)
  * Name: Passport Numbers Namespace for MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MACEDONIA, THE FORMER YUG…
* Identity: [passportNumNS-MLI](NamingSystem-passportNumNS-MLI.md)
  * Name: Passport Numbers Namespace for MALI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MALI. Used for the HL7 v…
* Identity: [passportNumNS-MLT](NamingSystem-passportNumNS-MLT.md)
  * Name: Passport Numbers Namespace for MALTA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MALTA. Used for the HL7 …
* Identity: [passportNumNS-MMR](NamingSystem-passportNumNS-MMR.md)
  * Name: Passport Numbers Namespace for MYANMAR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MYANMAR. Used for the HL…
* Identity: [passportNumNS-MNE](NamingSystem-passportNumNS-MNE.md)
  * Name: Passport Numbers Namespace for MONTENEGRO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MONTENEGRO. Used for the…
* Identity: [passportNumNS-MNG](NamingSystem-passportNumNS-MNG.md)
  * Name: Passport Numbers Namespace for MONGOLIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MONGOLIA. Used for the H…
* Identity: [passportNumNS-MNP](NamingSystem-passportNumNS-MNP.md)
  * Name: Passport Numbers Namespace for NORTHERN MARIANA ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NORTHERN MARIANA ISLANDS.…
* Identity: [passportNumNS-MOZ](NamingSystem-passportNumNS-MOZ.md)
  * Name: Passport Numbers Namespace for MOZAMBIQUE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MOZAMBIQUE. Used for the…
* Identity: [passportNumNS-MRT](NamingSystem-passportNumNS-MRT.md)
  * Name: Passport Numbers Namespace for MAURITANIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MAURITANIA. Used for the…
* Identity: [passportNumNS-MSR](NamingSystem-passportNumNS-MSR.md)
  * Name: Passport Numbers Namespace for MONTSERRAT
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MONTSERRAT. Used for the…
* Identity: [passportNumNS-MTQ](NamingSystem-passportNumNS-MTQ.md)
  * Name: Passport Numbers Namespace for MARTINIQUE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MARTINIQUE. Used for the…
* Identity: [passportNumNS-MUS](NamingSystem-passportNumNS-MUS.md)
  * Name: Passport Numbers Namespace for MAURITIUS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS. Used for the …
* Identity: [passportNumNS-MWI](NamingSystem-passportNumNS-MWI.md)
  * Name: Passport Numbers Namespace for MALAWI
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MALAWI. Used for the HL7…
* Identity: [passportNumNS-MYS](NamingSystem-passportNumNS-MYS.md)
  * Name: Passport Numbers Namespace for MALAYSIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MALAYSIA. Used for the H…
* Identity: [passportNumNS-MYT](NamingSystem-passportNumNS-MYT.md)
  * Name: Passport Numbers Namespace for MAYOTTE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of MAYOTTE. Used for the HL…
* Identity: [passportNumNS-NAM](NamingSystem-passportNumNS-NAM.md)
  * Name: Passport Numbers Namespace for NAMIBIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NAMIBIA. Used for the HL…
* Identity: [passportNumNS-NCL](NamingSystem-passportNumNS-NCL.md)
  * Name: Passport Numbers Namespace for NEW CALEDONIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NEW CALEDONIA. Used for …
* Identity: [passportNumNS-NER](NamingSystem-passportNumNS-NER.md)
  * Name: Passport Numbers Namespace for NIGER
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NIGER. Used for the HL7 …
* Identity: [passportNumNS-NFK](NamingSystem-passportNumNS-NFK.md)
  * Name: Passport Numbers Namespace for NORFOLK ISLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NORFOLK ISLAND. Used for…
* Identity: [passportNumNS-NGA](NamingSystem-passportNumNS-NGA.md)
  * Name: Passport Numbers Namespace for NIGERIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NIGERIA. Used for the HL…
* Identity: [passportNumNS-NIC](NamingSystem-passportNumNS-NIC.md)
  * Name: Passport Numbers Namespace for NICARAGUA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NICARAGUA. Used for the …
* Identity: [passportNumNS-NIU](NamingSystem-passportNumNS-NIU.md)
  * Name: Passport Numbers Namespace for NIUE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NIUE. Used for the HL7 v…
* Identity: [passportNumNS-NLD](NamingSystem-passportNumNS-NLD.md)
  * Name: Passport Numbers Namespace for NETHERLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS. Used for th…
* Identity: [passportNumNS-NOR](NamingSystem-passportNumNS-NOR.md)
  * Name: Passport Numbers Namespace for NORWAY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NORWAY. Used for the HL7…
* Identity: [passportNumNS-NPL](NamingSystem-passportNumNS-NPL.md)
  * Name: Passport Numbers Namespace for NEPAL
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NEPAL. Used for the HL7 …
* Identity: [passportNumNS-NRU](NamingSystem-passportNumNS-NRU.md)
  * Name: Passport Numbers Namespace for NAURU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NAURU. Used for the HL7 …
* Identity: [passportNumNS-NZL](NamingSystem-passportNumNS-NZL.md)
  * Name: Passport Numbers Namespace for NEW ZEALAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of NEW ZEALAND. Used for th…
* Identity: [passportNumNS-OMN](NamingSystem-passportNumNS-OMN.md)
  * Name: Passport Numbers Namespace for OMAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of OMAN. Used for the HL7 v…
* Identity: [passportNumNS-PAK](NamingSystem-passportNumNS-PAK.md)
  * Name: Passport Numbers Namespace for PAKISTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PAKISTAN. Used for the H…
* Identity: [passportNumNS-PAN](NamingSystem-passportNumNS-PAN.md)
  * Name: Passport Numbers Namespace for PANAMA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PANAMA. Used for the HL7…
* Identity: [passportNumNS-PCN](NamingSystem-passportNumNS-PCN.md)
  * Name: Passport Numbers Namespace for PITCAIRN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PITCAIRN. Used for the H…
* Identity: [passportNumNS-PER](NamingSystem-passportNumNS-PER.md)
  * Name: Passport Numbers Namespace for PERU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PERU. Used for the HL7 v…
* Identity: [passportNumNS-PHL](NamingSystem-passportNumNS-PHL.md)
  * Name: Passport Numbers Namespace for PHILIPPINES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PHILIPPINES. Used for th…
* Identity: [passportNumNS-PLW](NamingSystem-passportNumNS-PLW.md)
  * Name: Passport Numbers Namespace for PALAU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PALAU. Used for the HL7 …
* Identity: [passportNumNS-PNG](NamingSystem-passportNumNS-PNG.md)
  * Name: Passport Numbers Namespace for PAPUA NEW GUINEA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PAPUA NEW GUINEA. Used f…
* Identity: [passportNumNS-POL](NamingSystem-passportNumNS-POL.md)
  * Name: Passport Numbers Namespace for POLAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of POLAND. Used for the HL7…
* Identity: [passportNumNS-PRI](NamingSystem-passportNumNS-PRI.md)
  * Name: Passport Numbers Namespace for PUERTO RICO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PUERTO RICO. Used for th…
* Identity: [passportNumNS-PRK](NamingSystem-passportNumNS-PRK.md)
  * Name: Passport Numbers Namespace for KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of KOREA, DEMOCRATIC PEOPLE'…
* Identity: [passportNumNS-PRT](NamingSystem-passportNumNS-PRT.md)
  * Name: Passport Numbers Namespace for PORTUGAL
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PORTUGAL. Used for the H…
* Identity: [passportNumNS-PRY](NamingSystem-passportNumNS-PRY.md)
  * Name: Passport Numbers Namespace for PARAGUAY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PARAGUAY. Used for the H…
* Identity: [passportNumNS-PSE](NamingSystem-passportNumNS-PSE.md)
  * Name: Passport Numbers Namespace for PALESTINIAN TERRITORY, OCCUPIED
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of PALESTINIAN TERRITORY, OC…
* Identity: [passportNumNS-PYF](NamingSystem-passportNumNS-PYF.md)
  * Name: Passport Numbers Namespace for FRENCH POLYNESIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of FRENCH POLYNESIA. Used f…
* Identity: [passportNumNS-QAT](NamingSystem-passportNumNS-QAT.md)
  * Name: Passport Numbers Namespace for QATAR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of QATAR. Used for the HL7 …
* Identity: [passportNumNS-REU](NamingSystem-passportNumNS-REU.md)
  * Name: Passport Numbers Namespace for REUNION
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of REUNION. Used for the HL…
* Identity: [passportNumNS-ROU](NamingSystem-passportNumNS-ROU.md)
  * Name: Passport Numbers Namespace for ROMANIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ROMANIA. Used for the HL…
* Identity: [passportNumNS-RUS](NamingSystem-passportNumNS-RUS.md)
  * Name: Passport Numbers Namespace for RUSSIAN FEDERATION
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of RUSSIAN FEDERATION. Used…
* Identity: [passportNumNS-RWA](NamingSystem-passportNumNS-RWA.md)
  * Name: Passport Numbers Namespace for RWANDA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of RWANDA. Used for the HL7…
* Identity: [passportNumNS-SAU](NamingSystem-passportNumNS-SAU.md)
  * Name: Passport Numbers Namespace for SAUDI ARABIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAUDI ARABIA. Used for t…
* Identity: [passportNumNS-SDN](NamingSystem-passportNumNS-SDN.md)
  * Name: Passport Numbers Namespace for SUDAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SUDAN. Used for the HL7 …
* Identity: [passportNumNS-SEN](NamingSystem-passportNumNS-SEN.md)
  * Name: Passport Numbers Namespace for SENEGAL
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SENEGAL. Used for the HL…
* Identity: [passportNumNS-SGP](NamingSystem-passportNumNS-SGP.md)
  * Name: Passport Numbers Namespace for SINGAPORE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE. Used for the …
* Identity: [passportNumNS-SGS](NamingSystem-passportNumNS-SGS.md)
  * Name: Passport Numbers Namespace for SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SOUTH GEORGIA AND THE SOU…
* Identity: [passportNumNS-SHN](NamingSystem-passportNumNS-SHN.md)
  * Name: Passport Numbers Namespace for SAINT HELENA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT HELENA. Used for t…
* Identity: [passportNumNS-SJM](NamingSystem-passportNumNS-SJM.md)
  * Name: Passport Numbers Namespace for SVALBARD AND JAN MAYEN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SVALBARD AND JAN MAYEN. …
* Identity: [passportNumNS-SLB](NamingSystem-passportNumNS-SLB.md)
  * Name: Passport Numbers Namespace for SOLOMON ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SOLOMON ISLANDS. Used fo…
* Identity: [passportNumNS-SLE](NamingSystem-passportNumNS-SLE.md)
  * Name: Passport Numbers Namespace for SIERRA LEONE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SIERRA LEONE. Used for t…
* Identity: [passportNumNS-SLV](NamingSystem-passportNumNS-SLV.md)
  * Name: Passport Numbers Namespace for EL SALVADOR
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of EL SALVADOR. Used for th…
* Identity: [passportNumNS-SMR](NamingSystem-passportNumNS-SMR.md)
  * Name: Passport Numbers Namespace for SAN MARINO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAN MARINO. Used for the…
* Identity: [passportNumNS-SOM](NamingSystem-passportNumNS-SOM.md)
  * Name: Passport Numbers Namespace for SOMALIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SOMALIA. Used for the HL…
* Identity: [passportNumNS-SPM](NamingSystem-passportNumNS-SPM.md)
  * Name: Passport Numbers Namespace for SAINT PIERRE AND MIQUELON
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT PIERRE AND MIQUELON…
* Identity: [passportNumNS-SRB](NamingSystem-passportNumNS-SRB.md)
  * Name: Passport Numbers Namespace for SERBIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SERBIA. Used for the HL7…
* Identity: [passportNumNS-STP](NamingSystem-passportNumNS-STP.md)
  * Name: Passport Numbers Namespace for SAO TOME AND PRINCIPE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAO TOME AND PRINCIPE. U…
* Identity: [passportNumNS-SUR](NamingSystem-passportNumNS-SUR.md)
  * Name: Passport Numbers Namespace for SURINAME
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SURINAME. Used for the H…
* Identity: [passportNumNS-SVK](NamingSystem-passportNumNS-SVK.md)
  * Name: Passport Numbers Namespace for SLOVAKIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SLOVAKIA. Used for the H…
* Identity: [passportNumNS-SVN](NamingSystem-passportNumNS-SVN.md)
  * Name: Passport Numbers Namespace for SLOVENIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SLOVENIA. Used for the H…
* Identity: [passportNumNS-SWE](NamingSystem-passportNumNS-SWE.md)
  * Name: Passport Numbers Namespace for SWEDEN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SWEDEN. Used for the HL7…
* Identity: [passportNumNS-SWZ](NamingSystem-passportNumNS-SWZ.md)
  * Name: Passport Numbers Namespace for SWAZILAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SWAZILAND. Used for the …
* Identity: [passportNumNS-SYC](NamingSystem-passportNumNS-SYC.md)
  * Name: Passport Numbers Namespace for SEYCHELLES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SEYCHELLES. Used for the…
* Identity: [passportNumNS-SYR](NamingSystem-passportNumNS-SYR.md)
  * Name: Passport Numbers Namespace for SYRIAN ARAB REPUBLIC
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SYRIAN ARAB REPUBLIC. Us…
* Identity: [passportNumNS-TCA](NamingSystem-passportNumNS-TCA.md)
  * Name: Passport Numbers Namespace for TURKS AND CAICOS ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TURKS AND CAICOS ISLANDS.…
* Identity: [passportNumNS-TCD](NamingSystem-passportNumNS-TCD.md)
  * Name: Passport Numbers Namespace for CHAD
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of CHAD. Used for the HL7 v…
* Identity: [passportNumNS-TGO](NamingSystem-passportNumNS-TGO.md)
  * Name: Passport Numbers Namespace for TOGO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TOGO. Used for the HL7 v…
* Identity: [passportNumNS-THA](NamingSystem-passportNumNS-THA.md)
  * Name: Passport Numbers Namespace for THAILAND
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of THAILAND. Used for the H…
* Identity: [passportNumNS-TJK](NamingSystem-passportNumNS-TJK.md)
  * Name: Passport Numbers Namespace for TAJIKISTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TAJIKISTAN. Used for the…
* Identity: [passportNumNS-TKL](NamingSystem-passportNumNS-TKL.md)
  * Name: Passport Numbers Namespace for TOKELAU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TOKELAU. Used for the HL…
* Identity: [passportNumNS-TKM](NamingSystem-passportNumNS-TKM.md)
  * Name: Passport Numbers Namespace for TURKMENISTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TURKMENISTAN. Used for t…
* Identity: [passportNumNS-TLS](NamingSystem-passportNumNS-TLS.md)
  * Name: Passport Numbers Namespace for TIMOR-LESTE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TIMOR-LESTE. Used for th…
* Identity: [passportNumNS-TON](NamingSystem-passportNumNS-TON.md)
  * Name: Passport Numbers Namespace for TONGA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TONGA. Used for the HL7 …
* Identity: [passportNumNS-TTO](NamingSystem-passportNumNS-TTO.md)
  * Name: Passport Numbers Namespace for TRINIDAD AND TOBAGO
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TRINIDAD AND TOBAGO. Use…
* Identity: [passportNumNS-TUN](NamingSystem-passportNumNS-TUN.md)
  * Name: Passport Numbers Namespace for TUNISIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TUNISIA. Used for the HL…
* Identity: [passportNumNS-TUR](NamingSystem-passportNumNS-TUR.md)
  * Name: Passport Numbers Namespace for TURKEY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TURKEY. Used for the HL7…
* Identity: [passportNumNS-TUV](NamingSystem-passportNumNS-TUV.md)
  * Name: Passport Numbers Namespace for TUVALU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TUVALU. Used for the HL7…
* Identity: [passportNumNS-TWN](NamingSystem-passportNumNS-TWN.md)
  * Name: Passport Numbers Namespace for TAIWAN, PROVINCE OF CHINA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TAIWAN, PROVINCE OF CHINA…
* Identity: [passportNumNS-TZA](NamingSystem-passportNumNS-TZA.md)
  * Name: Passport Numbers Namespace for TANZANIA, UNITED REPUBLIC OF
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of TANZANIA, UNITED REPUBLIC…
* Identity: [passportNumNS-UGA](NamingSystem-passportNumNS-UGA.md)
  * Name: Passport Numbers Namespace for UGANDA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UGANDA. Used for the HL7…
* Identity: [passportNumNS-UKR](NamingSystem-passportNumNS-UKR.md)
  * Name: Passport Numbers Namespace for UKRAINE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UKRAINE. Used for the HL…
* Identity: [passportNumNS-UMI](NamingSystem-passportNumNS-UMI.md)
  * Name: Passport Numbers Namespace for UNITED STATES MINOR OUTLYING ISLANDS
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES MINOR OUTLY…
* Identity: [passportNumNS-URY](NamingSystem-passportNumNS-URY.md)
  * Name: Passport Numbers Namespace for URUGUAY
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of URUGUAY. Used for the HL…
* Identity: [passportNumNS-USA](NamingSystem-passportNumNS-USA.md)
  * Name: Passport Numbers Namespace for UNITED STATES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES. Used for …
* Identity: [passportNumNS-UZB](NamingSystem-passportNumNS-UZB.md)
  * Name: Passport Numbers Namespace for UZBEKISTAN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of UZBEKISTAN. Used for the…
* Identity: [passportNumNS-VAT](NamingSystem-passportNumNS-VAT.md)
  * Name: Passport Numbers Namespace for HOLY SEE (VATICAN CITY STATE)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of HOLY SEE (VATICAN CITY ST…
* Identity: [passportNumNS-VCT](NamingSystem-passportNumNS-VCT.md)
  * Name: Passport Numbers Namespace for SAINT VINCENT AND THE GRENADINES
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAINT VINCENT AND THE GRE…
* Identity: [passportNumNS-VEN](NamingSystem-passportNumNS-VEN.md)
  * Name: Passport Numbers Namespace for VENEZUELA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of VENEZUELA. Used for the …
* Identity: [passportNumNS-VGB](NamingSystem-passportNumNS-VGB.md)
  * Name: Passport Numbers Namespace for VIRGIN ISLANDS (BRITISH)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (BRITISH).…
* Identity: [passportNumNS-VIR](NamingSystem-passportNumNS-VIR.md)
  * Name: Passport Numbers Namespace for VIRGIN ISLANDS (U.S.)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (U.S.). U…
* Identity: [passportNumNS-VNM](NamingSystem-passportNumNS-VNM.md)
  * Name: Passport Numbers Namespace for VIET NAM
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of VIET NAM. Used for the H…
* Identity: [passportNumNS-VUT](NamingSystem-passportNumNS-VUT.md)
  * Name: Passport Numbers Namespace for VANUATU
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of VANUATU. Used for the HL…
* Identity: [passportNumNS-WLF](NamingSystem-passportNumNS-WLF.md)
  * Name: Passport Numbers Namespace for WALLIS AND FUTUNA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of WALLIS AND FUTUNA. Used …
* Identity: [passportNumNS-WSM](NamingSystem-passportNumNS-WSM.md)
  * Name: Passport Numbers Namespace for SAMOA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SAMOA. Used for the HL7 …
* Identity: [passportNumNS-YEM](NamingSystem-passportNumNS-YEM.md)
  * Name: Passport Numbers Namespace for YEMEN
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of YEMEN. Used for the HL7 …
* Identity: [passportNumNS-YUG](NamingSystem-passportNumNS-YUG.md)
  * Name: Passport Numbers Namespace for YUGOSLAVIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of YUGOSLAVIA. Used for the…
* Identity: [passportNumNS-ZAF](NamingSystem-passportNumNS-ZAF.md)
  * Name: Passport Numbers Namespace for SOUTH AFRICA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of SOUTH AFRICA. Used for t…
* Identity: [passportNumNS-ZMB](NamingSystem-passportNumNS-ZMB.md)
  * Name: Passport Numbers Namespace for ZAMBIA
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA. Used for the HL7…
* Identity: [passportNumNS-ZWE](NamingSystem-passportNumNS-ZWE.md)
  * Name: Passport Numbers Namespace for ZIMBABWE
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE. Used for the H…
* Identity: [ssn](NamingSystem-ssn.md)
  * Name: United States Social Security Number
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: United States Social Security Number (SSN). Assigned by the U.S. Social Security Administration. …
* Identity: [uri](NamingSystem-uri.md)
  * Name: Uniform Resource Identifier (URI)
  * Version: 1.0.0
  * Status: active
  * Owner: n/a
  * Copyright: n/a
  * Date: 2022-02-07
  * Description: As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs…
* Identity: [usb-address-identif…](NamingSystem-usb-address-identifier.md)
  * Name: USB VID and PID as a device identifier
  * Version: 1.0.0
  * Status: active
  * Owner: external
  * Copyright: n/a
  * Date: 2021-06-14
  * Description: A USB device that is plugged in identifies itself by its VID/PID combination. A VID is a 16-bit ven…
* Identity: [zigbee-address-iden…](NamingSystem-zigbee-address-identifier.md)
  * Name: ZigBee Address as a device identifier
  * Version: 1.0.0
  * Status: active
  * Owner: external
  * Copyright: n/a
  * Date: 2021-06-14
  * Description: The ZigBee Address is a unique 64-bit identifier assigned to each ZigBee device by the manufacturer…

Showing 320 of 320 entries

