# V2 Code Systems - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**HL7 Code Systems**](codesystems.md)
* **V2 Code Systems**

## V2 Code Systems

 These pages contain the code systems defined by HL7, and published in the Version 2 International Standards for use in the V2 product family. 

 Historically, the Version 2 terminology content was expressed in a legacy vocabulary model - Tables. In the evolution to a more modern and unified representation of terminology, all of the published content of these Version 2 Tables is now represented as Code Systems and Value Sets. The tables themselves, with their table-specific metadata, are here represented as concepts in the code system "V2Tables", which may be browsed below. The meta-data of each individual V2 table contains textual and usage information, and references to the code systems and value sets providing the codes for each Table; this may be viewed in the concept properties in the V2Tables code system. 

 All of this content has previousy been published in the HL7 Version 2 Standard, Chapter 2C Code Tables. This Code Tables chapter contains the code tables originally documented in individual chapters of the HL7 Version 2 Standard. As of HL7 Version 2.7, a proposal was accepted to move all of the tables to a common document. This separation allows these artifacts, which are often subject to more frequent change to meet regulatory requirements than the typical release cycles of ANSI Standards publication, to be available on a more responsive schedule than the rest of the standard. 

 This representation of the Version 2 coded content in code systems and value set will support use in, and harmonization with, the HL7 Implementation Guides and Standards published in HL7 FHIR, HL7 Version 3, and the HL7 Clinical Document Architecture. 

* Identity: 
  * Name: 
  * Version: 
  * Status: 
  * Content: 
  * Owner: 
  * Copyright: 
  * Date: 
  * Description: 
* Identity: [v2-0001](CodeSystem-v2-0001.md)
  * Name: administrativeSex
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a patient's sex for administrative purposes. Used in HL7 Versio…
* Identity: [v2-0002](CodeSystem-v2-0002.md)
  * Name: maritalStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.…
* Identity: [v2-0003](CodeSystem-v2-0003.md)
  * Name: event
  * Version: 2.13.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages…
* Identity: [v2-0004](CodeSystem-v2-0004.md)
  * Name: patientClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interface…
* Identity: [v2-0006](CodeSystem-v2-0006.md)
  * Name: religion2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the…
* Identity: [v2-0007](CodeSystem-v2-0007.md)
  * Name: admissionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the circumstances under which the patient was or will be admitte…
* Identity: [v2-0008](CodeSystem-v2-0008.md)
  * Name: acknowledgmentCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see mes…
* Identity: [v2-0009](CodeSystem-v2-0009.md)
  * Name: ambulatoryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying permanent or transient handicapped conditions of a person. Used…
* Identity: [v2-0012](CodeSystem-v2-0012.md)
  * Name: stockLocation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a stock location for older Version 2 messaging systems; not used…
* Identity: [v2-0017](CodeSystem-v2-0017.md)
  * Name: transactionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a type of financial transaction. Used in HL7 Version 2.x messag…
* Identity: [v2-0027](CodeSystem-v2-0027.md)
  * Name: priority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. …
* Identity: [v2-0033](CodeSystem-v2-0033.md)
  * Name: route
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate a means of administrating a medication dose. Use…
* Identity: [v2-0034](CodeSystem-v2-0034.md)
  * Name: siteAdministered
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used for medication administration sites. Used only in HL7 re…
* Identity: [v2-0038](CodeSystem-v2-0038.md)
  * Name: orderStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of an order. The purpose of these values …
* Identity: [v2-0048](CodeSystem-v2-0048.md)
  * Name: whatSubjectFilter
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the kind of information that is required to satis…
* Identity: [v2-0052](CodeSystem-v2-0052.md)
  * Name: diagnosisType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a type of diagnosis being sent. Used in HL7 Version 2.x messagi…
* Identity: [v2-0061](CodeSystem-v2-0061.md)
  * Name: checkDigitScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Versi…
* Identity: [v2-0062](CodeSystem-v2-0062.md)
  * Name: eventReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging i…
* Identity: [v2-0063](CodeSystem-v2-0063.md)
  * Name: relationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an actual personal relationship that the next of kin…
* Identity: [v2-0065](CodeSystem-v2-0065.md)
  * Name: specimenAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify actions to be taken with respect to the specimens…
* Identity: [v2-0066](CodeSystem-v2-0066.md)
  * Name: employmentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Ver…
* Identity: [v2-0069](CodeSystem-v2-0069.md)
  * Name: hospitalService
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the treatment or type of surgery the patient is scheduled to rec…
* Identity: [v2-0070](CodeSystem-v2-0070.md)
  * Name: specimenSourceCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify sources for speciments for clinical testing. The…
* Identity: [v2-0074](CodeSystem-v2-0074.md)
  * Name: diagnosticServiceSectionId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a section of a diagnostic service where the obser…
* Identity: [v2-0076](CodeSystem-v2-0076.md)
  * Name: messageType
  * Version: 2.12.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging…
* Identity: [v2-0080](CodeSystem-v2-0080.md)
  * Name: natureOfAbnormalTesting
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version…
* Identity: [v2-0083](CodeSystem-v2-0083.md)
  * Name: outlierType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-…
* Identity: [v2-0085](CodeSystem-v2-0085.md)
  * Name: observationResultStatusCodesInterpretation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify observation result status. These codes reflect th…
* Identity: [v2-0091](CodeSystem-v2-0091.md)
  * Name: queryPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a time frame in which a querry response is expect…
* Identity: [v2-0092](CodeSystem-v2-0092.md)
  * Name: re-admissionIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which are used to specify that a patient is being re admitted to a healthca…
* Identity: [v2-0098](CodeSystem-v2-0098.md)
  * Name: typeOfAgreement
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes to further identify an insurance plan. Used in HL7 Ver…
* Identity: [v2-0100](CodeSystem-v2-0100.md)
  * Name: invocationEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify codes for an event precipitating/triggering a cha…
* Identity: [v2-0102](CodeSystem-v2-0102.md)
  * Name: delayedAcknowledgmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a response type used in deferred processing two p…
* Identity: [v2-0103](CodeSystem-v2-0103.md)
  * Name: processingId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the message is part of a production, trai…
* Identity: [v2-0104](CodeSystem-v2-0104.md)
  * Name: versionId
  * Version: 2.12.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x fa…
* Identity: [v2-0105](CodeSystem-v2-0105.md)
  * Name: sourceOfComment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7…
* Identity: [v2-0106](CodeSystem-v2-0106.md)
  * Name: queryResponseFormat
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify which of several types of formats for data to be …
* Identity: [v2-0107](CodeSystem-v2-0107.md)
  * Name: deferredResponseType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify which type of deferred query resonse is desired, …
* Identity: [v2-0108](CodeSystem-v2-0108.md)
  * Name: queryResultsLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to control level of detail in query results. U…
* Identity: [v2-0109](CodeSystem-v2-0109.md)
  * Name: reportPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the priority associated with a report or update r…
* Identity: [v2-0116](CodeSystem-v2-0116.md)
  * Name: bedStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the state of a bed in an inpatient setting, and is used to de…
* Identity: [v2-0119](CodeSystem-v2-0119.md)
  * Name: orderControlCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are used to determine the function of the order segment. …
* Identity: [v2-0121](CodeSystem-v2-0121.md)
  * Name: responseFlag
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts allowing the placer (sending) application to determine the amou…
* Identity: [v2-0122](CodeSystem-v2-0122.md)
  * Name: chargeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify someone or something other than the patient to be…
* Identity: [v2-0123](CodeSystem-v2-0123.md)
  * Name: resultStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Ve…
* Identity: [v2-0124](CodeSystem-v2-0124.md)
  * Name: transportationMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify how (or whether) to transport a patient, when app…
* Identity: [v2-0126](CodeSystem-v2-0126.md)
  * Name: quantityLimitedRequest
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the maximum length of a query response that can b…
* Identity: [v2-0127](CodeSystem-v2-0127.md)
  * Name: allergenType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts speciying a classification of general allergy categories (drug, food, polle…
* Identity: [v2-0128](CodeSystem-v2-0128.md)
  * Name: allergySeverity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x …
* Identity: [v2-0130](CodeSystem-v2-0130.md)
  * Name: visitUserCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify categories of a patient's visit with respect to an individual…
* Identity: [v2-0131](CodeSystem-v2-0131.md)
  * Name: contactRole2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a relationship role that the next of kin/associated parties p…
* Identity: [v2-0133](CodeSystem-v2-0133.md)
  * Name: procedurePractitionerIdentifierCodeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined table of concepts which specify the different types of practitioners associated with th…
* Identity: [v2-0135](CodeSystem-v2-0135.md)
  * Name: assignmentOfBenefits
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which indicate whether an insured person agreed to assign the insurance ben…
* Identity: [v2-0137](CodeSystem-v2-0137.md)
  * Name: mailClaimParty
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a party to which a claim should be mailed when claims are sen…
* Identity: [v2-0140](CodeSystem-v2-0140.md)
  * Name: militaryService
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the military branch. This field is defined by CMS or other r…
* Identity: [v2-0142](CodeSystem-v2-0142.md)
  * Name: militaryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the military status of the patient. This field is defined b…
* Identity: [v2-0144](CodeSystem-v2-0144.md)
  * Name: eligibilitySource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the source of information about the insured's eligibility fo…
* Identity: [v2-0145](CodeSystem-v2-0145.md)
  * Name: roomType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC…
* Identity: [v2-0146](CodeSystem-v2-0146.md)
  * Name: amountType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in …
* Identity: [v2-0147](CodeSystem-v2-0147.md)
  * Name: policyType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PT…
* Identity: [v2-0148](CodeSystem-v2-0148.md)
  * Name: moneyOrPercentageIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the amount is currency or a percentage. …
* Identity: [v2-0149](CodeSystem-v2-0149.md)
  * Name: dayType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify whether the days are denied, pending or approved. Used in H…
* Identity: [v2-0150](CodeSystem-v2-0150.md)
  * Name: certificationPatientType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the category or type of patient for which this certification…
* Identity: [v2-0155](CodeSystem-v2-0155.md)
  * Name: accept-applicationAcknowledgmentConditions
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which identify conditions under which accept acknowledgments ar…
* Identity: [v2-0156](CodeSystem-v2-0156.md)
  * Name: whichDate-timeQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify a type of date referred to in query specifications…
* Identity: [v2-0157](CodeSystem-v2-0157.md)
  * Name: whichDate-timeStatusQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify the status type of objects selected in a date rang…
* Identity: [v2-0158](CodeSystem-v2-0158.md)
  * Name: date-timeSelectionQualifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of conceptss that allow the specification of certain types of values within…
* Identity: [v2-0159](CodeSystem-v2-0159.md)
  * Name: dietCodeSpecificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version…
* Identity: [v2-0160](CodeSystem-v2-0160.md)
  * Name: trayType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version…
* Identity: [v2-0161](CodeSystem-v2-0161.md)
  * Name: allowSubstitution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether substitutions are allowed and, if so, th…
* Identity: [v2-0162](CodeSystem-v2-0162.md)
  * Name: routeOfAdministration
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messag…
* Identity: [v2-0163](CodeSystem-v2-0163.md)
  * Name: bodySite
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Us…
* Identity: [v2-0164](CodeSystem-v2-0164.md)
  * Name: administrationDevice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the mechanical device used to aid in the administration of t…
* Identity: [v2-0165](CodeSystem-v2-0165.md)
  * Name: administrationMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify the specific method requested for the administration of the …
* Identity: [v2-0166](CodeSystem-v2-0166.md)
  * Name: rxComponentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x …
* Identity: [v2-0167](CodeSystem-v2-0167.md)
  * Name: substitutionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.…
* Identity: [v2-0168](CodeSystem-v2-0168.md)
  * Name: processingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify one or more available priorities for performing …
* Identity: [v2-0169](CodeSystem-v2-0169.md)
  * Name: reportingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the available priorities reporting the test resu…
* Identity: [v2-0170](CodeSystem-v2-0170.md)
  * Name: derivedSpecimen
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the parents and children for diagnostic studies,…
* Identity: [v2-0173](CodeSystem-v2-0173.md)
  * Name: coordinationOfBenefits
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether this insurance works in conjunction with other insurance…
* Identity: [v2-0174](CodeSystem-v2-0174.md)
  * Name: natureOfServiceTestObservation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identification of a test battery, an entire functional proced…
* Identity: [v2-0175](CodeSystem-v2-0175.md)
  * Name: masterFileIdentifierCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Mas…
* Identity: [v2-0177](CodeSystem-v2-0177.md)
  * Name: confidentialityCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the degree to which special confidentiality protection should be…
* Identity: [v2-0178](CodeSystem-v2-0178.md)
  * Name: file-levelEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Ver…
* Identity: [v2-0179](CodeSystem-v2-0179.md)
  * Name: responseLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying application response levels defined for a given Mast…
* Identity: [v2-0180](CodeSystem-v2-0180.md)
  * Name: masterfileActionCode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Vers…
* Identity: [v2-0181](CodeSystem-v2-0181.md)
  * Name: mfnRecord-levelErrorReturn
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the requested update. Site-defined table, specifi…
* Identity: [v2-0183](CodeSystem-v2-0183.md)
  * Name: active-inactive
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether a person is currently a valid staff member. …
* Identity: [v2-0185](CodeSystem-v2-0185.md)
  * Name: preferredMethodOfContact
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the pr…
* Identity: [v2-0187](CodeSystem-v2-0187.md)
  * Name: providerBilling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Versi…
* Identity: [v2-0189](CodeSystem-v2-0189.md)
  * Name: ethnicGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts further defining a patient's ancestry. In the US, a current use is to use …
* Identity: [v2-0190](CodeSystem-v2-0190.md)
  * Name: addressType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.…
* Identity: [v2-0191](CodeSystem-v2-0191.md)
  * Name: typeOfReferencedData
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts declaring the general type of media data that is encoded. Used…
* Identity: [v2-0193](CodeSystem-v2-0193.md)
  * Name: amountClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in…
* Identity: [v2-0200](CodeSystem-v2-0200.md)
  * Name: nameType2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for types of names for persons. Used in HL7 Version 2.x messag…
* Identity: [v2-0201](CodeSystem-v2-0201.md)
  * Name: telecommunicationUse
  * Version: 4.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for specifying a specific use of a telecommunication number. B…
* Identity: [v2-0202](CodeSystem-v2-0202.md)
  * Name: telecommunicationEquipmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best pr…
* Identity: [v2-0203](CodeSystem-v2-0203.md)
  * Name: identifierType
  * Version: 5.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2022-12-07
  * Description: HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messagin…
* Identity: [v2-0204](CodeSystem-v2-0204.md)
  * Name: organizationalNameType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of name for an organization i.e., legal name, disp…
* Identity: [v2-0205](CodeSystem-v2-0205.md)
  * Name: priceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing …
* Identity: [v2-0206](CodeSystem-v2-0206.md)
  * Name: segmentAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 versi…
* Identity: [v2-0207](CodeSystem-v2-0207.md)
  * Name: processingMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate an archival process or an initial load process. …
* Identity: [v2-0208](CodeSystem-v2-0208.md)
  * Name: queryResponseStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining precise response status concepts in support of HL7 Ver…
* Identity: [v2-0209](CodeSystem-v2-0209.md)
  * Name: relationalOperator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define the relationship between HL7 segment field names…
* Identity: [v2-0210](CodeSystem-v2-0210.md)
  * Name: relationalConjunction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used with relationalOperator values to group more than one segm…
* Identity: [v2-0211](CodeSystem-v2-0211.md)
  * Name: alternateCharacterSets
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the character set(s) in use. Includes both sin…
* Identity: [v2-0213](CodeSystem-v2-0213.md)
  * Name: purgeStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a visit relative to its place in a purge workfl…
* Identity: [v2-0214](CodeSystem-v2-0214.md)
  * Name: specialProgram
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to record a health insurance program required for healthcare visit rei…
* Identity: [v2-0215](CodeSystem-v2-0215.md)
  * Name: publicity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a level of publicity of information about a patient for a specif…
* Identity: [v2-0216](CodeSystem-v2-0216.md)
  * Name: patientStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a care episode for a patient. Used in HL7 Vers…
* Identity: [v2-0217](CodeSystem-v2-0217.md)
  * Name: visitPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define a relative level of urgency applied to a patient visit. Use…
* Identity: [v2-0220](CodeSystem-v2-0220.md)
  * Name: livingArrangement
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts characterizing the situation that patient-associated parties live in at the…
* Identity: [v2-0223](CodeSystem-v2-0223.md)
  * Name: livingDependency2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependen…
* Identity: [v2-0224](CodeSystem-v2-0224.md)
  * Name: transportArranged
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining whether patient transportation preparations are in pla…
* Identity: [v2-0225](CodeSystem-v2-0225.md)
  * Name: escortRequired
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts defining whether patient transportation preparations are in pla…
* Identity: [v2-0228](CodeSystem-v2-0228.md)
  * Name: diagnosisClassification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Us…
* Identity: [v2-0230](CodeSystem-v2-0230.md)
  * Name: procedureFunctionalType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify a procedure. Used in HL7 Version 2.x messaging in the PR1…
* Identity: [v2-0231](CodeSystem-v2-0231.md)
  * Name: studentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to designate whether a guarantor is a full or part time student. Used…
* Identity: [v2-0232](CodeSystem-v2-0232.md)
  * Name: insuranceCompanyContactReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe why an insurance company has been contacted. Used in HL7 …
* Identity: [v2-0234](CodeSystem-v2-0234.md)
  * Name: reportTiming
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the time span of a report or the reason for a …
* Identity: [v2-0235](CodeSystem-v2-0235.md)
  * Name: reportSource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify where a report sender learned about an event. …
* Identity: [v2-0236](CodeSystem-v2-0236.md)
  * Name: eventReportedTo
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the type of entity to which the even has been …
* Identity: [v2-0237](CodeSystem-v2-0237.md)
  * Name: eventQualification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to qualify an event related to a product experience. Used…
* Identity: [v2-0238](CodeSystem-v2-0238.md)
  * Name: eventSeriousness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used by a sender to designate an event as serious or significan…
* Identity: [v2-0239](CodeSystem-v2-0239.md)
  * Name: eventExpected
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to communicate whether an event has been judged to be expe…
* Identity: [v2-0240](CodeSystem-v2-0240.md)
  * Name: eventConsequence
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the impact of an event on a patient. Used in …
* Identity: [v2-0241](CodeSystem-v2-0241.md)
  * Name: patientOutcome
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the overall state of a patient as a result of …
* Identity: [v2-0242](CodeSystem-v2-0242.md)
  * Name: primaryObserverQualification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to provide a general description of the kind of health car…
* Identity: [v2-0243](CodeSystem-v2-0243.md)
  * Name: identityMayBeDivulged
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define whether the primary observer has given permissio…
* Identity: [v2-0247](CodeSystem-v2-0247.md)
  * Name: statusOfEvaluation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describes the status of product evaluation. Used in HL7 V…
* Identity: [v2-0248](CodeSystem-v2-0248.md)
  * Name: productSource
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the evaluation state of a product identified i…
* Identity: [v2-0250](CodeSystem-v2-0250.md)
  * Name: relatednessAssessment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to provide an estimate of whether an issue with a product…
* Identity: [v2-0251](CodeSystem-v2-0251.md)
  * Name: actionTakenInResponseToTheEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define the action taken as a result of an event related…
* Identity: [v2-0252](CodeSystem-v2-0252.md)
  * Name: causalityObservations
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to record event observations regarding what may have cause…
* Identity: [v2-0253](CodeSystem-v2-0253.md)
  * Name: indirectExposureMechanism
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the mechanism of product transmission when the…
* Identity: [v2-0254](CodeSystem-v2-0254.md)
  * Name: kindOfQuantity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7 published code system of concepts that describe categories of an underlying kind of property re…
* Identity: [v2-0255](CodeSystem-v2-0255.md)
  * Name: durationCategories
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to classify an observation definition as intended to measure a patient…
* Identity: [v2-0256](CodeSystem-v2-0256.md)
  * Name: timeDelayPostChallenge
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to classify an observation definition as being a component…
* Identity: [v2-0257](CodeSystem-v2-0257.md)
  * Name: natureOfChallenge
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to further describe an observation definition that is char…
* Identity: [v2-0258](CodeSystem-v2-0258.md)
  * Name: relationshipModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used in an observation definition to describe the subject of an…
* Identity: [v2-0260](CodeSystem-v2-0260.md)
  * Name: patientLocationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the kind of location described in the location definition.…
* Identity: [v2-0261](CodeSystem-v2-0261.md)
  * Name: locationEquipment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the equipment available in a location definition identifie…
* Identity: [v2-0262](CodeSystem-v2-0262.md)
  * Name: privacyLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the level of privacy a patient will be afforded when assig…
* Identity: [v2-0263](CodeSystem-v2-0263.md)
  * Name: levelOfCare
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the level of care a patient may be afforded when assigned …
* Identity: [v2-0265](CodeSystem-v2-0265.md)
  * Name: specialtyType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the specialty of the care professional who is supported wh…
* Identity: [v2-0267](CodeSystem-v2-0267.md)
  * Name: daysOfTheWeek
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to identify the day(s) of the week when a location may be …
* Identity: [v2-0268](CodeSystem-v2-0268.md)
  * Name: override
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define whether a Charge Description Master description may be overr…
* Identity: [v2-0269](CodeSystem-v2-0269.md)
  * Name: chargeOnIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the event upon which a charge should be generated. Used in …
* Identity: [v2-0270](CodeSystem-v2-0270.md)
  * Name: documentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x mes…
* Identity: [v2-0271](CodeSystem-v2-0271.md)
  * Name: documentCompletionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to record the state of a document in a workflow. Used in …
* Identity: [v2-0272](CodeSystem-v2-0272.md)
  * Name: documentConfidentialityStatus2
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concetps used to identify the degree to which special confidentiality pr…
* Identity: [v2-0273](CodeSystem-v2-0273.md)
  * Name: documentAvailabilityStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define whether a patient document is appropriate or ava…
* Identity: [v2-0275](CodeSystem-v2-0275.md)
  * Name: documentStorageStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to describe the availability of a document in relation to …
* Identity: [v2-0276](CodeSystem-v2-0276.md)
  * Name: appointmentReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe the kind of appointment or the reason why an appointment h…
* Identity: [v2-0277](CodeSystem-v2-0277.md)
  * Name: appointmentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used in an appointment request to describe the kind of appointment. Used i…
* Identity: [v2-0278](CodeSystem-v2-0278.md)
  * Name: fillerStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe an appointment status from the perspective of the entity a…
* Identity: [v2-0279](CodeSystem-v2-0279.md)
  * Name: allowSubstitution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to indicate whether the appointment resource may be substituted for an…
* Identity: [v2-0280](CodeSystem-v2-0280.md)
  * Name: referralPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to designate the urgency of a referral. Used in HL7 Version 2.x mess…
* Identity: [v2-0281](CodeSystem-v2-0281.md)
  * Name: referralType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the general category of healthcare professional desired to…
* Identity: [v2-0282](CodeSystem-v2-0282.md)
  * Name: referralDisposition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to identify the expected response from the healthcare professional rec…
* Identity: [v2-0283](CodeSystem-v2-0283.md)
  * Name: referralStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the state of a referral. Used in HL7 Version 2.x messaging…
* Identity: [v2-0284](CodeSystem-v2-0284.md)
  * Name: referralCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe the patient care setting where a referral should take plac…
* Identity: [v2-0286](CodeSystem-v2-0286.md)
  * Name: providerRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the relationship between a referral recipient and a patient …
* Identity: [v2-0287](CodeSystem-v2-0287.md)
  * Name: problem-goalAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used…
* Identity: [v2-0290](CodeSystem-v2-0290.md)
  * Name: mimeBase64EncodingCharacters
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the characters used in the MIME Base 64 encoding mec…
* Identity: [v2-0294](CodeSystem-v2-0294.md)
  * Name: timeSelectionCriteriaParameterClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to describe acceptable start and end times, as well as days of the wee…
* Identity: [v2-0298](CodeSystem-v2-0298.md)
  * Name: cpRangeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to define a type of range used in composite pricing in fin…
* Identity: [v2-0299](CodeSystem-v2-0299.md)
  * Name: encoding
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concept identifying the type of encoding used to represent successive oc…
* Identity: [v2-0301](CodeSystem-v2-0301.md)
  * Name: universalIdType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messagin…
* Identity: [v2-0305](CodeSystem-v2-0305.md)
  * Name: personLocationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the categorization of the person's location. Used in HL7 Versio…
* Identity: [v2-0309](CodeSystem-v2-0309.md)
  * Name: coverageType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of insurance coverage or what types of services are cov…
* Identity: [v2-0311](CodeSystem-v2-0311.md)
  * Name: jobStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the next of kin/associated party's job status. Used…
* Identity: [v2-0315](CodeSystem-v2-0315.md)
  * Name: livingWillCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether or not the patient has a living will and, if so, whether…
* Identity: [v2-0316](CodeSystem-v2-0316.md)
  * Name: organDonorCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the patient wants to donate his/her organs and whether a…
* Identity: [v2-0317](CodeSystem-v2-0317.md)
  * Name: annotations
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the coded entry associated with a given point in time during the…
* Identity: [v2-0321](CodeSystem-v2-0321.md)
  * Name: dispenseMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-definde code system of concepts specifying the method by which treatment is dispensed. Used in…
* Identity: [v2-0322](CodeSystem-v2-0322.md)
  * Name: completionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the treatment administration event seg…
* Identity: [v2-0323](CodeSystem-v2-0323.md)
  * Name: actionCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are …
* Identity: [v2-0324](CodeSystem-v2-0324.md)
  * Name: locationCharacteristic
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identifier code to show which characteristic is being communi…
* Identity: [v2-0325](CodeSystem-v2-0325.md)
  * Name: locationRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an identifier code to show which relationship is being communica…
* Identity: [v2-0326](CodeSystem-v2-0326.md)
  * Name: visitIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the level on which data are being sent. It is the indicator use…
* Identity: [v2-0329](CodeSystem-v2-0329.md)
  * Name: quantityMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the method by which the quantity distributed is…
* Identity: [v2-0330](CodeSystem-v2-0330.md)
  * Name: marketingBasis
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the basis for marketing approval. Used in HL7…
* Identity: [v2-0331](CodeSystem-v2-0331.md)
  * Name: facilityType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x…
* Identity: [v2-0332](CodeSystem-v2-0332.md)
  * Name: sourceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x…
* Identity: [v2-0334](CodeSystem-v2-0334.md)
  * Name: disabilityInformationRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify to which person the disability information relates in the m…
* Identity: [v2-0335](CodeSystem-v2-0335.md)
  * Name: repeatPattern
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the interval between repeated services. Used in HL7 Versio…
* Identity: [v2-0336](CodeSystem-v2-0336.md)
  * Name: referralReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for which the referral will take place. Used in…
* Identity: [v2-0337](CodeSystem-v2-0337.md)
  * Name: certificationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the status of the practitioner's speciality cer…
* Identity: [v2-0339](CodeSystem-v2-0339.md)
  * Name: advancedBeneficiaryNotice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the patient's or the patient's representative's co…
* Identity: [v2-0344](CodeSystem-v2-0344.md)
  * Name: patientsRelationshipToInsured
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the relationship of the patient to the insured, as defined …
* Identity: [v2-0353](CodeSystem-v2-0353.md)
  * Name: cweStatuses
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of comcepts that represent an exception identifier code; that is, a code th…
* Identity: [v2-0354](CodeSystem-v2-0354.md)
  * Name: messageStructure
  * Version: 2.10.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of abstract message structure codes. Each code identifies a specific messag…
* Identity: [v2-0355](CodeSystem-v2-0355.md)
  * Name: primaryKeyValueType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type for the master file record identifier.…
* Identity: [v2-0356](CodeSystem-v2-0356.md)
  * Name: alternateCharacterSetHandlingScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concept that specify the scheme used when any alternative character sets…
* Identity: [v2-0357](CodeSystem-v2-0357.md)
  * Name: messageErrorCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ER…
* Identity: [v2-0359](CodeSystem-v2-0359.md)
  * Name: diagnosisPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the significance or priority of the diagnosis code. Note tha…
* Identity: [v2-0360](CodeSystem-v2-0360.md)
  * Name: degreeLicenseCertificate
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (nam…
* Identity: [v2-0364](CodeSystem-v2-0364.md)
  * Name: commentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the type of comment text being sent in the specific comment r…
* Identity: [v2-0365](CodeSystem-v2-0365.md)
  * Name: equipmentState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the status the equipment was in at the time the t…
* Identity: [v2-0366](CodeSystem-v2-0366.md)
  * Name: local-remoteControlState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the current state of control associated with the …
* Identity: [v2-0367](CodeSystem-v2-0367.md)
  * Name: alertLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highes…
* Identity: [v2-0368](CodeSystem-v2-0368.md)
  * Name: remoteControlCommand
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the comment the component is to initiate. Used in the Equipm…
* Identity: [v2-0369](CodeSystem-v2-0369.md)
  * Name: specimenRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x me…
* Identity: [v2-0370](CodeSystem-v2-0370.md)
  * Name: containerStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the status of the unique container in which the …
* Identity: [v2-0371](CodeSystem-v2-0371.md)
  * Name: additivePreservative
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying any additive introduced to the specimen before or at…
* Identity: [v2-0372](CodeSystem-v2-0372.md)
  * Name: specimenComponent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc. Us…
* Identity: [v2-0373](CodeSystem-v2-0373.md)
  * Name: treatment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen treatment performed during lab processing. Used…
* Identity: [v2-0374](CodeSystem-v2-0374.md)
  * Name: systemInducedContaminants
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the specimen contaminant identifier associated with the speci…
* Identity: [v2-0375](CodeSystem-v2-0375.md)
  * Name: artificialBlood
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the artificial blood identifier associated with the specimen.…
* Identity: [v2-0376](CodeSystem-v2-0376.md)
  * Name: specialHandling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts describing how a specimen and/or container needs to be handled from the tim…
* Identity: [v2-0377](CodeSystem-v2-0377.md)
  * Name: environmentalFactors
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the other environmental factors associated with the specimen …
* Identity: [v2-0383](CodeSystem-v2-0383.md)
  * Name: substanceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the status of the inventoried item. The status ind…
* Identity: [v2-0384](CodeSystem-v2-0384.md)
  * Name: substanceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x me…
* Identity: [v2-0387](CodeSystem-v2-0387.md)
  * Name: commandResponse
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying the response of the previously issued command. Used in HL7 Ver…
* Identity: [v2-0388](CodeSystem-v2-0388.md)
  * Name: processingType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the processing type that applies to the test code. …
* Identity: [v2-0389](CodeSystem-v2-0389.md)
  * Name: analyteRepeatStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. orig…
* Identity: [v2-0391](CodeSystem-v2-0391.md)
  * Name: segmentGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the optional segment groups which are to be included…
* Identity: [v2-0392](CodeSystem-v2-0392.md)
  * Name: matchReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying what search components (e.g., name, birthdate, social security …
* Identity: [v2-0393](CodeSystem-v2-0393.md)
  * Name: matchAlgorithms
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts identifying the name or identity of the specific search algorithm to which …
* Identity: [v2-0394](CodeSystem-v2-0394.md)
  * Name: responseModality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying the timing and grouping of the response message(s).…
* Identity: [v2-0395](CodeSystem-v2-0395.md)
  * Name: modifyIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying whether the subscription is new or is being modifie…
* Identity: [v2-0396](CodeSystem-v2-0396.md)
  * Name: codingSystem
  * Version: 4.2.0
  * Status: active
  * Content: complete
  * Owner: [vocab](http://www.hl7.org/Special/committees/Vocab)
  * Copyright: THO
  * Date: 2025-07-15
  * Description: HL7-defined code system of concepts specifying the coding system. This table is maintained outside…
* Identity: [v2-0397](CodeSystem-v2-0397.md)
  * Name: sequencing
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if s…
* Identity: [v2-0398](CodeSystem-v2-0398.md)
  * Name: continuationStyle
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts identifying whether it is a fragmented message or part of an in…
* Identity: [v2-0401](CodeSystem-v2-0401.md)
  * Name: governmentReimbursementProgram
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes that indicate an agency that the practitioner is author…
* Identity: [v2-0402](CodeSystem-v2-0402.md)
  * Name: schoolType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify a categorization of an academic institution that grants a deg…
* Identity: [v2-0403](CodeSystem-v2-0403.md)
  * Name: languageAbility
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts which specify codes that indicate the ability that a Staff Member possesses…
* Identity: [v2-0404](CodeSystem-v2-0404.md)
  * Name: languageProficiency
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesse…
* Identity: [v2-0406](CodeSystem-v2-0406.md)
  * Name: organizationUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which identify an environment in which a provider acts in a spe…
* Identity: [v2-0409](CodeSystem-v2-0409.md)
  * Name: applicationChangeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the type of change being requested (if NMR query)…
* Identity: [v2-0415](CodeSystem-v2-0415.md)
  * Name: drgTransferType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, …
* Identity: [v2-0416](CodeSystem-v2-0416.md)
  * Name: procedureDrgType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DR…
* Identity: [v2-0417](CodeSystem-v2-0417.md)
  * Name: tissueType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of tissue removed from a patient during a …
* Identity: [v2-0418](CodeSystem-v2-0418.md)
  * Name: procedurePriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the significance or priority of a procedure code.…
* Identity: [v2-0421](CodeSystem-v2-0421.md)
  * Name: severityOfIllness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the ranking of a patient’s illness. Used in HL7 …
* Identity: [v2-0422](CodeSystem-v2-0422.md)
  * Name: triageType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a patient’s prioritization within the context of …
* Identity: [v2-0423](CodeSystem-v2-0423.md)
  * Name: caseCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify reasons that a non-urgent patient presents to the…
* Identity: [v2-0424](CodeSystem-v2-0424.md)
  * Name: gestationCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the status of a birth in relation to the gestatio…
* Identity: [v2-0425](CodeSystem-v2-0425.md)
  * Name: newbornType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify whether the baby was born in or out of a specifie…
* Identity: [v2-0426](CodeSystem-v2-0426.md)
  * Name: bloodProduct
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of blood product. Used in HL7 Version 2 m…
* Identity: [v2-0427](CodeSystem-v2-0427.md)
  * Name: riskManagementIncident
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s…
* Identity: [v2-0428](CodeSystem-v2-0428.md)
  * Name: incidentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify a classification of types of incidents. Used in …
* Identity: [v2-0429](CodeSystem-v2-0429.md)
  * Name: productionClass
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code and/or text indicating the primary use for which the l…
* Identity: [v2-0430](CodeSystem-v2-0430.md)
  * Name: arrivalMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying how the patient was brought to the healthcare facility. Used in…
* Identity: [v2-0431](CodeSystem-v2-0431.md)
  * Name: recreationalDrugType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying what recreational drugs the patient uses. Used in HL7 Version 2…
* Identity: [v2-0432](CodeSystem-v2-0432.md)
  * Name: admissionLevelOfCare
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the acuity level assigned to the patient at the time of admissi…
* Identity: [v2-0433](CodeSystem-v2-0433.md)
  * Name: precaution
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying non-clincal precautions that need to be taken with the patient.…
* Identity: [v2-0434](CodeSystem-v2-0434.md)
  * Name: patientCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the patient's current medical condition for the purpose of commu…
* Identity: [v2-0435](CodeSystem-v2-0435.md)
  * Name: advanceDirective
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the patient's instructions to the healthcare facility. Used in …
* Identity: [v2-0436](CodeSystem-v2-0436.md)
  * Name: sensitivityToCausativeAgent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the patient should not be exposed to a substance. Us…
* Identity: [v2-0437](CodeSystem-v2-0437.md)
  * Name: alertDevice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any type of allergy alert device the patient may be carrying or …
* Identity: [v2-0438](CodeSystem-v2-0438.md)
  * Name: allergyClinicalStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the verification status for the allergy. Used in HL7 Version 2.…
* Identity: [v2-0440](CodeSystem-v2-0440.md)
  * Name: dataTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the format of the observation value in the Observati…
* Identity: [v2-0441](CodeSystem-v2-0441.md)
  * Name: immunizationRegistryStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the immunization registry status of the patient. Used in HL7 Ve…
* Identity: [v2-0442](CodeSystem-v2-0442.md)
  * Name: locationServiceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the types of services provided by the location. Used in HL7 Ve…
* Identity: [v2-0443](CodeSystem-v2-0443.md)
  * Name: providerRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the functional involvement with the activity being transmitted (…
* Identity: [v2-0444](CodeSystem-v2-0444.md)
  * Name: nameAssemblyOrder
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the preferred display order of the components of this person nam…
* Identity: [v2-0445](CodeSystem-v2-0445.md)
  * Name: identityReliability
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reliability of patient/person identifying data transmitted v…
* Identity: [v2-0450](CodeSystem-v2-0450.md)
  * Name: eventType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of event of the message. Used in HL7 Versi…
* Identity: [v2-0457](CodeSystem-v2-0457.md)
  * Name: overallClaimDisposition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the final status of the claim. Used in HL7 Version 2.x messagin…
* Identity: [v2-0465](CodeSystem-v2-0465.md)
  * Name: name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying an indication of the representation provided by the …
* Identity: [v2-0466](CodeSystem-v2-0466.md)
  * Name: ambulatoryPaymentClassification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code. Used …
* Identity: [v2-0468](CodeSystem-v2-0468.md)
  * Name: paymentAdjustmentInformation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any payment adjustment due to drugs or medical devices. Used in…
* Identity: [v2-0469](CodeSystem-v2-0469.md)
  * Name: packagingStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x me…
* Identity: [v2-0470](CodeSystem-v2-0470.md)
  * Name: reimbursementType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the fee schedule reimbursement type applied to the line item. U…
* Identity: [v2-0472](CodeSystem-v2-0472.md)
  * Name: tqConjunctionId
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying that a second timing specification is to follow usin…
* Identity: [v2-0473](CodeSystem-v2-0473.md)
  * Name: formularyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether or not the service (pharmaceutical) is in the formulary.…
* Identity: [v2-0474](CodeSystem-v2-0474.md)
  * Name: organizationUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the classification of the organization unit. Used in HL7 Versio…
* Identity: [v2-0475](CodeSystem-v2-0475.md)
  * Name: chargeTypeReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the choice of, and providing the clinical rationale for, a selec…
* Identity: [v2-0477](CodeSystem-v2-0477.md)
  * Name: controlledSubstanceSchedule
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the class of the drug or other substance if its usage is control…
* Identity: [v2-0478](CodeSystem-v2-0478.md)
  * Name: formularyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part …
* Identity: [v2-0480](CodeSystem-v2-0480.md)
  * Name: pharmacyOrderTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the general category of pharmacy order which may be …
* Identity: [v2-0482](CodeSystem-v2-0482.md)
  * Name: orderType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient …
* Identity: [v2-0483](CodeSystem-v2-0483.md)
  * Name: authorizationMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts of forms of authorization a recorder may receive from the respo…
* Identity: [v2-0484](CodeSystem-v2-0484.md)
  * Name: dispenseType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of dispensing event that occurred. Used in HL7 Version…
* Identity: [v2-0485](CodeSystem-v2-0485.md)
  * Name: extendedPriorityCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts describing the urgency of a request carried in an order. Used in HL7 Versi…
* Identity: [v2-0487](CodeSystem-v2-0487.md)
  * Name: specimenType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describe the precise nature of an entity that may be used …
* Identity: [v2-0488](CodeSystem-v2-0488.md)
  * Name: specimenCollectionMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the specimen collection method. Used in HL7 Version…
* Identity: [v2-0489](CodeSystem-v2-0489.md)
  * Name: risks
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally inf…
* Identity: [v2-0490](CodeSystem-v2-0490.md)
  * Name: specimenRejectReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/an…
* Identity: [v2-0491](CodeSystem-v2-0491.md)
  * Name: specimenQuality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the degree or grade of excellence of the specimen at receipt. U…
* Identity: [v2-0492](CodeSystem-v2-0492.md)
  * Name: specimenAppropriateness
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the suitability of the specimen for the particular planned use a…
* Identity: [v2-0493](CodeSystem-v2-0493.md)
  * Name: specimenCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a mode or state of being that describes the nature of the specim…
* Identity: [v2-0494](CodeSystem-v2-0494.md)
  * Name: specimenChildRole
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying for child specimens the relationship between this sp…
* Identity: [v2-0495](CodeSystem-v2-0495.md)
  * Name: bodySiteModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the modifier for the body site. Used in HL7 Version…
* Identity: [v2-0496](CodeSystem-v2-0496.md)
  * Name: consentType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying to what the subject is consenting, i.e. what type of service, su…
* Identity: [v2-0497](CodeSystem-v2-0497.md)
  * Name: consentMode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the method in which a subject provides consent. Use…
* Identity: [v2-0498](CodeSystem-v2-0498.md)
  * Name: consentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-code system of concepts specifying whether the consent has been sought and granted. Used in HL…
* Identity: [v2-0499](CodeSystem-v2-0499.md)
  * Name: consentBypassReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the subject's consent was not sought. Used in HL7 Ve…
* Identity: [v2-0500](CodeSystem-v2-0500.md)
  * Name: consentDisclosureLevel
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how much information was disclosed to the subject as…
* Identity: [v2-0501](CodeSystem-v2-0501.md)
  * Name: consentNon-disclosureReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify a reason the subject did not receive full disclosure. Used…
* Identity: [v2-0502](CodeSystem-v2-0502.md)
  * Name: non-subjectConsenterReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify a reason consent was granted by a person other…
* Identity: [v2-0503](CodeSystem-v2-0503.md)
  * Name: sequenceResultsFlag
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the sequencing relationship between the curren…
* Identity: [v2-0504](CodeSystem-v2-0504.md)
  * Name: sequenceCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the relationship between the start/end of the r…
* Identity: [v2-0505](CodeSystem-v2-0505.md)
  * Name: cyclicEntryExitIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify if this service request is the first or last se…
* Identity: [v2-0506](CodeSystem-v2-0506.md)
  * Name: serviceRequestRelationship
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an additional or alternate relationship between…
* Identity: [v2-0507](CodeSystem-v2-0507.md)
  * Name: observationResultHandling
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts regarding the handling of a result. For example, an order may specify that…
* Identity: [v2-0508](CodeSystem-v2-0508.md)
  * Name: bloodProductProcessingRequirements
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify additional information about the blood component class asso…
* Identity: [v2-0510](CodeSystem-v2-0510.md)
  * Name: bloodProductDispenseStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the current status of the specified blood produ…
* Identity: [v2-0511](CodeSystem-v2-0511.md)
  * Name: bpObservationStatusCodesInterpretation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the interpretation for the blood product observ…
* Identity: [v2-0513](CodeSystem-v2-0513.md)
  * Name: bloodProductTransfusion-dispositionStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the current status of the specified blood produ…
* Identity: [v2-0514](CodeSystem-v2-0514.md)
  * Name: transfusionAdverseReaction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of adverse reaction that the recipient of the bloo…
* Identity: [v2-0516](CodeSystem-v2-0516.md)
  * Name: errorSeverity
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the severity of an application error as reported dur…
* Identity: [v2-0517](CodeSystem-v2-0517.md)
  * Name: informInstructions
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying who (if anyone) should or should not be informed of an error. U…
* Identity: [v2-0518](CodeSystem-v2-0518.md)
  * Name: overrideType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify what type of override can be used to override the specific …
* Identity: [v2-0520](CodeSystem-v2-0520.md)
  * Name: messageWaitingPriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts which specify the disposition of the patient at time of dischar…
* Identity: [v2-0523](CodeSystem-v2-0523.md)
  * Name: computationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify if the change is computed as a percent change o…
* Identity: [v2-0524](CodeSystem-v2-0524.md)
  * Name: sequenceCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle …
* Identity: [v2-0527](CodeSystem-v2-0527.md)
  * Name: calendarAlignment
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e…
* Identity: [v2-0528](CodeSystem-v2-0528.md)
  * Name: eventRelatedPeriod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Use…
* Identity: [v2-0529](CodeSystem-v2-0529.md)
  * Name: precision
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the degree of precision of the time stamp (Y = year,…
* Identity: [v2-0530](CodeSystem-v2-0530.md)
  * Name: organization-Agency-Department
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the agency or department that assigned the identifier in co…
* Identity: [v2-0532](CodeSystem-v2-0532.md)
  * Name: expandedYes-NoIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator t…
* Identity: [v2-0534](CodeSystem-v2-0534.md)
  * Name: clergyNotificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the clergy should be notified. Used in HL7 Version 2 me…
* Identity: [v2-0535](CodeSystem-v2-0535.md)
  * Name: signatureType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that indicate how a patient/subscriber authorization signature is obtained …
* Identity: [v2-0536](CodeSystem-v2-0536.md)
  * Name: certificateStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the certificate held by the health professional. …
* Identity: [v2-0538](CodeSystem-v2-0538.md)
  * Name: institutionRelationshipType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relationship the staff person has with the institution for w…
* Identity: [v2-0540](CodeSystem-v2-0540.md)
  * Name: inactiveReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason the staff member is inactive. Used in HL7 Version 2 …
* Identity: [v2-0544](CodeSystem-v2-0544.md)
  * Name: containerCondition
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify at each receipt the status of the container in…
* Identity: [v2-0547](CodeSystem-v2-0547.md)
  * Name: jurisdictionalBreadth
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the breadth/extent of the jurisdiction where the qualification i…
* Identity: [v2-0548](CodeSystem-v2-0548.md)
  * Name: signatorysRelationshipToSubject
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [sd](http://www.hl7.org/Special/committees/structure)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relationship of the consenter to the subject. Used in HL7 V…
* Identity: [v2-0550](CodeSystem-v2-0550.md)
  * Name: bodyParts
  * Version: 3.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the part of the body. Used in HL7 Version 2 messagi…
* Identity: [v2-0553](CodeSystem-v2-0553.md)
  * Name: invoiceControl
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify what action is being performed by this message. Used in th…
* Identity: [v2-0554](CodeSystem-v2-0554.md)
  * Name: invoiceReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for this invoice. Used in the Invoice (IVC) seg…
* Identity: [v2-0555](CodeSystem-v2-0555.md)
  * Name: invoiceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of invoice. Used in the Invoice (IVC) segment in …
* Identity: [v2-0556](CodeSystem-v2-0556.md)
  * Name: benefitGroup
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the benefit group. Used in the Invoice (IVC) segment in HL…
* Identity: [v2-0557](CodeSystem-v2-0557.md)
  * Name: payeeType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the type of payee (e.g., organization, person). Used in th…
* Identity: [v2-0558](CodeSystem-v2-0558.md)
  * Name: payeeRelationshipToInvoice
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the relationship to the invoice for Person Payee Types. Us…
* Identity: [v2-0559](CodeSystem-v2-0559.md)
  * Name: product-serviceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the processing status for the Product/Service Code. Used i…
* Identity: [v2-0560](CodeSystem-v2-0560.md)
  * Name: Quantity Units
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the adjustment quantity.
* Identity: [v2-0561](CodeSystem-v2-0561.md)
  * Name: product-servicesClarification
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the Product/Service Code. Used in the Product/Service Line…
* Identity: [v2-0562](CodeSystem-v2-0562.md)
  * Name: processingConsideration
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify special processing requested of Payer for this Product/Serv…
* Identity: [v2-0564](CodeSystem-v2-0564.md)
  * Name: adjustmentCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the category of adjustment and is used to assist in determi…
* Identity: [v2-0565](CodeSystem-v2-0565.md)
  * Name: providerAdjustmentReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the reason for this adjustment. Used in the Adjustment (AD…
* Identity: [v2-0566](CodeSystem-v2-0566.md)
  * Name: bloodUnitType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to specify the type of blood unit. Used in the Blood Unit…
* Identity: [v2-0569](CodeSystem-v2-0569.md)
  * Name: adjustmentAction
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the action requested of the party that receives an adjustme…
* Identity: [v2-0570](CodeSystem-v2-0570.md)
  * Name: paymentMethod
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the method for the movement of payment. Used in the Paymen…
* Identity: [v2-0571](CodeSystem-v2-0571.md)
  * Name: invoiceProcessingResultsStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the processing status for an Invoice Processing Result. Us…
* Identity: [v2-0572](CodeSystem-v2-0572.md)
  * Name: taxStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to specify the tax status of the provider. Used in the Invoice (IVC) …
* Identity: [v2-0615](CodeSystem-v2-0615.md)
  * Name: userAuthenticationCredentialType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying a type of user authentication credential. Used in H…
* Identity: [v2-0616](CodeSystem-v2-0616.md)
  * Name: addressExpirationReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason this address was marked as "ended". Used in HL7 Vers…
* Identity: [v2-0617](CodeSystem-v2-0617.md)
  * Name: addressUsage
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying how an address is intended to be used. Used in HL7 …
* Identity: [v2-0618](CodeSystem-v2-0618.md)
  * Name: protection
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying that an address needs to be treated with special care or sensiti…
* Identity: [v2-0625](CodeSystem-v2-0625.md)
  * Name: itemStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the state of an inventory item within the context of an inven…
* Identity: [v2-0634](CodeSystem-v2-0634.md)
  * Name: itemImportance
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that denote a level or importance of an inventory item within the context o…
* Identity: [v2-0642](CodeSystem-v2-0642.md)
  * Name: reorderTheory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the calculation method used to determine the resupply schedul…
* Identity: [v2-0651](CodeSystem-v2-0651.md)
  * Name: laborCalculationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the method used to calculate employee labor and measure emplo…
* Identity: [v2-0653](CodeSystem-v2-0653.md)
  * Name: dateFormat
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that identify the date format for a decontamination/sterilization instance.…
* Identity: [v2-0657](CodeSystem-v2-0657.md)
  * Name: deviceType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that idenfity the kind of device as defined by the manufacturer. Used in HL…
* Identity: [v2-0659](CodeSystem-v2-0659.md)
  * Name: lotControl
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that define whether the sterilization load for a device is built in the sub…
* Identity: [v2-0667](CodeSystem-v2-0667.md)
  * Name: deviceDataState
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that define the state of the data as provided from a device. Used in HL7 Ve…
* Identity: [v2-0669](CodeSystem-v2-0669.md)
  * Name: loadStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts used to define the status of the information provided in a device steriliza…
* Identity: [v2-0682](CodeSystem-v2-0682.md)
  * Name: deviceStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts that communicate the state of a device. Used in HL7 Version 2.x messaging i…
* Identity: [v2-0702](CodeSystem-v2-0702.md)
  * Name: cycleType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of cycle that is being executed. A cycle type is a sp…
* Identity: [v2-0717](CodeSystem-v2-0717.md)
  * Name: accessRestrictionValue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [pa](http://www.hl7.org/Special/committees/pafm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the information to which access is restricted. Used in HL7 Vers…
* Identity: [v2-0728](CodeSystem-v2-0728.md)
  * Name: cclValue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the clinical complexity level (CCL) value for the determined dia…
* Identity: [v2-0731](CodeSystem-v2-0731.md)
  * Name: drgDiagnosisDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related g…
* Identity: [v2-0734](CodeSystem-v2-0734.md)
  * Name: grouperStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of a grouper in general. US Realm. Used in HL7 Versi…
* Identity: [v2-0739](CodeSystem-v2-0739.md)
  * Name: drgStatusPatient
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying whether the length of stay is normal or respectively shorter or …
* Identity: [v2-0742](CodeSystem-v2-0742.md)
  * Name: drgStatusFinancialCalculation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the diagnosis related group (DRG) calculation rega…
* Identity: [v2-0749](CodeSystem-v2-0749.md)
  * Name: drgGroupingStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the gender information for diagnosis re…
* Identity: [v2-0755](CodeSystem-v2-0755.md)
  * Name: drgstatusWeightAtBirth
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the weight at birth for diagnosis relat…
* Identity: [v2-0757](CodeSystem-v2-0757.md)
  * Name: drgStatusRespirationMinutes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of the respiration minutes information for…
* Identity: [v2-0759](CodeSystem-v2-0759.md)
  * Name: drgstatusAdmission
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the admission status for the diagnosis related group (DRG) deter…
* Identity: [v2-0761](CodeSystem-v2-0761.md)
  * Name: drgProcedureDeterminationStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status of the use of this particular procedure for the diagn…
* Identity: [v2-0763](CodeSystem-v2-0763.md)
  * Name: drgProcedureRelevance
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the relevance of this particular procedure for the diagnosis rel…
* Identity: [v2-0776](CodeSystem-v2-0776.md)
  * Name: itemStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [mnm](http://www.hl7.org/Special/committees/mnm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the status (useful for reporting and item usage purposes) that a…
* Identity: [v2-0778](CodeSystem-v2-0778.md)
  * Name: itemType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying a classification of material items into like groups as defined a…
* Identity: [v2-0790](CodeSystem-v2-0790.md)
  * Name: approvingRegulatoryAgency
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the regulatory agency by which the item has been approved, such …
* Identity: [v2-0793](CodeSystem-v2-0793.md)
  * Name: rulingAct
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying an act containing a rule that the item is legally required to be…
* Identity: [v2-0806](CodeSystem-v2-0806.md)
  * Name: sterilizationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the type of sterilization used for sterilizing the inventory sup…
* Identity: [v2-0818](CodeSystem-v2-0818.md)
  * Name: package
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the packaging unit in which this inventory supply item can be or…
* Identity: [v2-0834](CodeSystem-v2-0834.md)
  * Name: mimeTypes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the general type of data. Used in HL7 Version 2.x messaging in …
* Identity: [v2-0868](CodeSystem-v2-0868.md)
  * Name: telecommunicationExpirationReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the reason this contact number/email was marked as "ended". Use…
* Identity: [v2-0871](CodeSystem-v2-0871.md)
  * Name: supplyRisk
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying any known or suspected hazard associated with this material item…
* Identity: [v2-0881](CodeSystem-v2-0881.md)
  * Name: roleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the account role of the physician, for example, only billing for…
* Identity: [v2-0882](CodeSystem-v2-0882.md)
  * Name: medicalRoleExecutingPhysician
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the role of the physician ("self-employed" or "employed"). Used…
* Identity: [v2-0894](CodeSystem-v2-0894.md)
  * Name: sideOfBody
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the side of the body ("left" or "right"). Used in HL7 Version 2…
* Identity: [v2-0904](CodeSystem-v2-0904.md)
  * Name: securityCheckScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [inm](http://www.hl7.org/Special/committees/inm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the scheme for the security check. Used in HL7 Vers…
* Identity: [v2-0905](CodeSystem-v2-0905.md)
  * Name: shipmentStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the shipment. Used in HL7 Version 2.x…
* Identity: [v2-0906](CodeSystem-v2-0906.md)
  * Name: actpriority
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the priority for the shipment. Used in HL7 Version …
* Identity: [v2-0907](CodeSystem-v2-0907.md)
  * Name: confidentiality
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 V…
* Identity: [v2-0909](CodeSystem-v2-0909.md)
  * Name: patientResultsReleaseCategorizationScheme
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the scheme for the patient results release categoriz…
* Identity: [v2-0912](CodeSystem-v2-0912.md)
  * Name: participation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that represent functional involvement of a caregiver or member …
* Identity: [v2-0914](CodeSystem-v2-0914.md)
  * Name: rootCause
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX se…
* Identity: [v2-0916](CodeSystem-v2-0916.md)
  * Name: relevantClincialInformation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying additional clinical information about the patient or specimen to…
* Identity: [v2-0917](CodeSystem-v2-0917.md)
  * Name: bolusType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of bolus. Used in HL7 Version 2.x messagin…
* Identity: [v2-0918](CodeSystem-v2-0918.md)
  * Name: pcaType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of PCA. Used in HL7 Version 2.x messaging …
* Identity: [v2-0919](CodeSystem-v2-0919.md)
  * Name: exclusiveTest
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that define if a test should be a specific event with no other …
* Identity: [v2-0920](CodeSystem-v2-0920.md)
  * Name: preferredSpecimen-AttributeStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that indicate whether a Specimen/Attribute is Preferred or Alte…
* Identity: [v2-0921](CodeSystem-v2-0921.md)
  * Name: certificationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code for the certification type. Used in HL7 Version 2.x me…
* Identity: [v2-0922](CodeSystem-v2-0922.md)
  * Name: certificationCategory
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the code for the certification category. Used in HL7 Version 2.…
* Identity: [v2-0923](CodeSystem-v2-0923.md)
  * Name: processInterruption
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying whether the process was interrrupted and whether the…
* Identity: [v2-0924](CodeSystem-v2-0924.md)
  * Name: cumulativeDosageLimitUom
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit. Used…
* Identity: [v2-0925](CodeSystem-v2-0925.md)
  * Name: phlebotomyIssue
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the phlebotomy issue. Used in HL7 Version 2.x messa…
* Identity: [v2-0926](CodeSystem-v2-0926.md)
  * Name: phlebotomyStatus
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the status of the phlebotomy. Used in HL7 Version 2…
* Identity: [v2-0927](CodeSystem-v2-0927.md)
  * Name: armStick
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the arm(s) receiving the stick. Used in HL7 Version…
* Identity: [v2-0933](CodeSystem-v2-0933.md)
  * Name: intendedProcedureType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of intended procedure. Used in HL7 Version…
* Identity: [v2-0935](CodeSystem-v2-0935.md)
  * Name: processInterruptionReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL…
* Identity: [v2-0936](CodeSystem-v2-0936.md)
  * Name: observationType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying types of observations to enable systems to distingui…
* Identity: [v2-0937](CodeSystem-v2-0937.md)
  * Name: observationSubtype
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the observation sub-type. Used in HL7 Version 2.x m…
* Identity: [v2-0938](CodeSystem-v2-0938.md)
  * Name: collectionEvent
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the limit for the collection event or process step. …
* Identity: [v2-0939](CodeSystem-v2-0939.md)
  * Name: communicationLocation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the communication location. Used in HL7 Version 2.x…
* Identity: [v2-0940](CodeSystem-v2-0940.md)
  * Name: limitationTypeCode
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x mes…
* Identity: [v2-0942](CodeSystem-v2-0942.md)
  * Name: equipmentStateIndicator
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated…
* Identity: [v2-0945](CodeSystem-v2-0945.md)
  * Name: auto-DilutionType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the i…
* Identity: [v2-0946](CodeSystem-v2-0946.md)
  * Name: supplierType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code system that Identifies the type of supplier that will distribute the supply items associated t…
* Identity: [v2-0948](CodeSystem-v2-0948.md)
  * Name: v2CS-relationshipType
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that identify the type of relationship identified by Relationsh…
* Identity: [v2-0949](CodeSystem-v2-0949.md)
  * Name: orderControlCodeReason
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used …
* Identity: [v2-0950](CodeSystem-v2-0950.md)
  * Name: orderStatusModifier
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts used to further define the status identified in ORC-5. Used in…
* Identity: [v2-0951](CodeSystem-v2-0951.md)
  * Name: reasonForStudy
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [oo](http://www.hl7.org/Special/committees/orders)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined code system of concepts that provide additional information to the universal service id…
* Identity: [v2-0970](CodeSystem-v2-0970.md)
  * Name: onlineVerificationResult
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code values used to indicate the result of an online verification of insurance data.
* Identity: [v2-0971](CodeSystem-v2-0971.md)
  * Name: onlineVerificationResultErrorCodes
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [fm](http://www.hl7.org/Special/committees/fm)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: Code values representing a type of error from a failed operation to perform online verification of …
* Identity: [v2-4000](CodeSystem-v2-4000.md)
  * Name: name-addressRepresentation
  * Version: 2.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: THO
  * Date: 2019-12-01
  * Description: HL7-defined cdoe system of concepts that provide an indication of the kind of representation provid…
* Identity: [v2-tables](CodeSystem-v2-tables.md)
  * Name: V2 Table List
  * Version: 6.0.0
  * Status: active
  * Content: complete
  * Owner: [HL7](http://hl7.org)
  * Copyright: CC0
  * Date: 2025-02-24
  * Description: Master List of V2 TablesPlease note that V2 Code System and Value Set URIs are present, but the…

Showing 416 of 416 entries

