# x_BillableProduct - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **x_BillableProduct**

## ValueSet: x_BillableProduct 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-xBillableProduct | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:XBillableProduct |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19867 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**The billable codes selected for Clinical Product Invoices. Steward is Financial Management. 

 **References** 

* Included into [MaterialEntityClassType](ValueSet-v3-MaterialEntityClassType.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-EntityCode`](CodeSystem-v3-EntityCode.md)version 📦3.0.0 where concept descends from [_x_BillableProduct](CodeSystem-v3-EntityCode.md#v3-EntityCode-_x_BillableProduct)
* Import all the codes that are contained in [SpecimenAdditiveEntity](ValueSet-v3-SpecimenAdditiveEntity.md)
* Import all the codes that are contained in [ContainerEntityType](ValueSet-v3-ContainerEntityType.md)
* Import all the codes that are contained in [MedicalDevice](ValueSet-v3-MedicalDevice.md)
* Import all the codes that are contained in [VaccineEntityType](ValueSet-v3-VaccineEntityType.md)

 

### Expansion

This value set contains 108 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-xBillableProduct",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-xBillableProduct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19867"
    }
  ],
  "version" : "3.0.0",
  "name" : "XBillableProduct",
  "title" : "x_BillableProduct",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:**The billable codes selected for Clinical Product Invoices. Steward is Financial Management.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "descendent-of",
            "value" : "_x_BillableProduct"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-SpecimenAdditiveEntity"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ContainerEntityType"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-MedicalDevice"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-VaccineEntityType"]
      }
    ]
  }
}

```
