# SecurityCategoryObservationValue - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SecurityCategoryObservationValue**

## ValueSet: SecurityCategoryObservationValue 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-SecurityCategoryObservationValue | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SecurityCategoryObservationValue |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20470 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Security observation values used to indicate security category metadata. V:SecurityCategoryObservationValue is the union of V:PrivacyPolicyType, V:ActPrivacyLaw, V:ActConsentDirective, V:InformationSensitivityPolicy, V:ActInformationSensitivityPolicy, V:RoleInformationSensitivityPolicy, V:EntityInformationSensitivityPolicy, and the V:ActConsentType value used to populate the SecurityCategoryObservationValue attribute in order to convey one or more nonhierarchical categories of sensitivity metadata, which are used to control access to data more finely than with hierarchical security classification alone. Could be bound R1 to a V:ActUSPrivacyPolicy in a future US Realm. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Import all the codes that are contained in [ActConsentType](ValueSet-v3-ActConsentType.md)
* Import all the codes that are contained in [ActPrivacyPolicy](ValueSet-v3-ActPrivacyPolicy.md)
* Import all the codes that are contained in [ActConsentDirective](ValueSet-v3-ActConsentDirective.md)
* Import all the codes that are contained in [ActPrivacyLaw](ValueSet-v3-ActPrivacyLaw.md)
* Import all the codes that are contained in [InformationSensitivityPolicy](ValueSet-v3-InformationSensitivityPolicy.md)
* Import all the codes that are contained in [ActInformationSensitivityPolicy](ValueSet-v3-ActInformationSensitivityPolicy.md)
* Import all the codes that are contained in [RoleInformationSensitivityPolicy](ValueSet-v3-RoleInformationSensitivityPolicy.md)
* Import all the codes that are contained in [EntityInformationSensitivityPolicy](ValueSet-v3-EntityInformationSensitivityPolicy.md)
* Import all the codes that are contained in [Compartment](ValueSet-v3-Compartment.md)
* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v3-ObservationValue`](CodeSystem-v3-ObservationValue.md)version 📦4.0.0

 

### Expansion

This value set contains 377 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-SecurityCategoryObservationValue",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-SecurityCategoryObservationValue",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20470"
    }
  ],
  "version" : "3.0.0",
  "name" : "SecurityCategoryObservationValue",
  "title" : "SecurityCategoryObservationValue",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Security observation values used to indicate security category metadata. V:SecurityCategoryObservationValue is the union of V:PrivacyPolicyType, V:ActPrivacyLaw, V:ActConsentDirective, V:InformationSensitivityPolicy, V:ActInformationSensitivityPolicy, V:RoleInformationSensitivityPolicy, V:EntityInformationSensitivityPolicy, and the V:ActConsentType value used to populate the SecurityCategoryObservationValue attribute in order to convey one or more nonhierarchical categories of sensitivity metadata, which are used to control access to data more finely than with hierarchical security classification alone. Could be bound R1 to a V:ActUSPrivacyPolicy in a future US Realm.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActConsentType"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActPrivacyPolicy"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActConsentDirective"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActPrivacyLaw"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-InformationSensitivityPolicy"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ActInformationSensitivityPolicy"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-RoleInformationSensitivityPolicy"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-EntityInformationSensitivityPolicy"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-Compartment"]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationValue"
      }
    ]
  }
}

```
