# RouteOfAdministration - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RouteOfAdministration**

## ValueSet: RouteOfAdministration 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-RouteOfAdministration | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RouteOfAdministration |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.14581 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The path the administered medication takes to get into the body or into contact with the body. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Import all the codes that are contained in [RouteByMethod](ValueSet-v3-RouteByMethod.md)
* Import all the codes that are contained in [RouteBySite](ValueSet-v3-RouteBySite.md)
* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration`](CodeSystem-v3-RouteOfAdministration.md)version 📦3.0.0

 

### Expansion

This value set contains 391 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-RouteOfAdministration",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-RouteOfAdministration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.14581"
    }
  ],
  "version" : "3.0.0",
  "name" : "RouteOfAdministration",
  "title" : "RouteOfAdministration",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The path the administered medication takes to get into the body or into contact with the body.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-RouteByMethod"]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-RouteBySite"]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration"
      }
    ]
  }
}

```
