# PlaceEntityType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlaceEntityType**

## ValueSet: PlaceEntityType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-PlaceEntityType | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PlaceEntityType |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16100 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Types of places for EntityClass "PLC" 

 **References** 

* Included into [EntityCode](ValueSet-v3-EntityCode.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-EntityCode`](CodeSystem-v3-EntityCode.md)version 📦3.0.0 where concept is-a [_PlaceEntityType](CodeSystem-v3-EntityCode.md#v3-EntityCode-_PlaceEntityType)
* Import all the codes that are contained in [CountryEntityType](ValueSet-v3-CountryEntityType.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-EntityCode`](CodeSystem-v3-EntityCode.md)version 📦3.0.0

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem EntityCode v3.0.0 (CodeSystem)](CodeSystem-v3-EntityCode.md)
* codesystem unknown version 2018
* [valueset CountryEntityType v3.0.0 (ValueSet)](ValueSet-v3-CountryEntityType.md)

This value set contains 752 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-PlaceEntityType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-PlaceEntityType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16100"
    }
  ],
  "version" : "3.0.0",
  "name" : "PlaceEntityType",
  "title" : "PlaceEntityType",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Types of places for EntityClass \"PLC\"",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_PlaceEntityType"
          }
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-CountryEntityType"]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "concept" : [
          {
            "code" : "_PlaceEntityType"
          }
        ]
      }
    ]
  }
}

```
