# ActClassCluster - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActClassCluster**

## ValueSet: ActClassCluster 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActClassCluster | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActClassCluster |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20204 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A group of entries within a composition, topic or category that have a logical association with one another. 
The representation of a single observation or action might itself be multi-part. The data might need to be represented as a nested set of values, as a table, list, or as a time series. The Cluster class permits such aggregation within an entry for such compound data. 
Examples include "Haematology investigations" which might include two or more distinct batteries. 
A cluster may contain batteries and/or individual entries 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActClass`](CodeSystem-v3-ActClass.md)version 📦4.0.0 where concept is-a [CLUSTER](CodeSystem-v3-ActClass.md#v3-ActClass-CLUSTER)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActClassCluster",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActClassCluster",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20204"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActClassCluster",
  "title" : "ActClassCluster",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A group of entries within a composition, topic or category that have a logical association with one another.\r\n\r\nThe representation of a single observation or action might itself be multi-part. The data might need to be represented as a nested set of values, as a table, list, or as a time series. The Cluster class permits such aggregation within an entry for such compound data.\r\n\r\nExamples include \"Haematology investigations\" which might include two or more distinct batteries.\r\n\r\nA cluster may contain batteries and/or individual entries",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "CLUSTER"
          }
        ]
      }
    ]
  }
}

```
