# PHVS_ManufacturersOfVaccinesMVX_CDC_NIP - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PHVS_ManufacturersOfVaccinesMVX_CDC_NIP**

## ValueSet: PHVS_ManufacturersOfVaccinesMVX_CDC_NIP 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v2-0227 | *Version*:4.0.0 | |
| Active as of 2023-06-12 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PHVSManufacturersOfVaccinesMVXCDCNIP |
| *Other Identifiers:*OID:2.16.840.1.114222.4.11.826 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Value Set of codes that specify the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed via[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227) 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://hl7.org/fhir/sid/mvx`](http://tx.fhir.org/r5)version ⏿20201030

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v2-0227",
  "url" : "http://terminology.hl7.org/ValueSet/v2-0227",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.114222.4.11.826"
    }
  ],
  "version" : "4.0.0",
  "name" : "PHVSManufacturersOfVaccinesMVXCDCNIP",
  "title" : "PHVS_ManufacturersOfVaccinesMVX_CDC_NIP",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-06-12",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes that specify the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed via [https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/sid/mvx"
      }
    ]
  }
}

```
