# PHVS_Race_HL7_2x - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PHVS_Race_HL7_2x**

## ValueSet: PHVS_Race_HL7_2x 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v2-0005 | *Version*:4.0.0 | |
| Active as of 2021-09-01 | *Responsible:*Health Level Seven International | *Computable Name*:PHVSRaceHL72x |
| *Other Identifiers:*OID:2.16.840.1.114222.4.11.6065 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This race value set is based upon CDC check-digit codes, but using the HL7 table 0005. HL7 adopted the CDC Race and Ethnicity codes in HL7 Table 0005 in 2005. This value set has been created for backward compatibility and some historic Implementation guides (E.g. Immunization). Recommend using Race Category value set based upon CDC Race & Ethnicity code system. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v2-0005",
  "url" : "http://terminology.hl7.org/ValueSet/v2-0005",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.114222.4.11.6065"
    }
  ],
  "version" : "4.0.0",
  "name" : "PHVSRaceHL72x",
  "title" : "PHVS_Race_HL7_2x",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-09-01",
  "publisher" : "Health Level Seven International",
  "description" : "This race value set is based upon CDC check-digit codes, but using the HL7 table 0005. HL7 adopted the CDC Race and Ethnicity codes in HL7 Table 0005 in 2005. This value set has been created for backward compatibility and some historic Implementation guides (E.g. Immunization). Recommend using Race Category value set based upon CDC Race & Ethnicity code system.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "urn:oid:2.16.840.1.113883.6.238",
        "concept" : [
          {
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          },
          {
            "code" : "2028-9",
            "display" : "Asian"
          },
          {
            "code" : "2054-5",
            "display" : "Black or African American"
          },
          {
            "code" : "2076-8",
            "display" : "Native Hawaiian or Other Pacific Islander"
          },
          {
            "code" : "2106-3",
            "display" : "White"
          },
          {
            "code" : "2131-1",
            "display" : "Other Race"
          }
        ]
      }
    ]
  }
}

```
