# Time Period Ranges - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Time Period Ranges**

## ValueSet: Time Period Ranges 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/time-period-ranges | *Version*:1.0.0 | |
| Active as of 2025-06-27 | *Responsible:*[HL7 International Clinical Quality Information Work Group](http://hl7.org/Special/committees/cqi) | *Computable Name*:TimePeriodRanges |
| **Copyright/Legal**: Adapted from content published by IHE Copyright (c) 2015[IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property). Used here according to the terms of the[CC BY 4 License](https://creativecommons.org/licenses/by/4.0/). Makes use of duration definitions as defined in the[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html)specification. | | |

 
All codes in the Time Period Ranges code system. Note that this value set is typically not expanded because the full set contains millions of codes, the set of all possible ranges of time periods expressible within the grammar. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/time-period-ranges`](CodeSystem-time-period-ranges.md)version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "time-period-ranges",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/time-period-ranges",
  "version" : "1.0.0",
  "name" : "TimePeriodRanges",
  "title" : "Time Period Ranges",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-06-27",
  "publisher" : "HL7 International Clinical Quality Information Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/Special/committees/cqi"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "cqi@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "All codes in the Time Period Ranges code system. Note that this value set is typically not expanded because the full set contains millions of codes, the set of all possible ranges of time periods expressible within the grammar.",
  "immutable" : true,
  "copyright" : "Adapted from content published by IHE Copyright (c) 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property). Used here according to the terms of the [CC BY 4 License](https://creativecommons.org/licenses/by/4.0/). Makes use of duration definitions as defined in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) specification.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/time-period-ranges"
      }
    ]
  }
}

```
