# AMA CPT All Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AMA CPT All Codes**

## ValueSet: AMA CPT All Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/cpt-all | *Version*:1.0.0 | |
| Active as of 2023-08-05 | *Responsible:*[Health Level Seven International](http://hl7.org/fhir) | *Computable Name*:AmaCPTAllCodes |
| **Copyright/Legal**: CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association. | | |

 
All codes in CPT (including metadata, modifiers, etc). 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in `http://www.ama-assn.org/go/cpt`version Not Stated (use latest from terminology server)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cpt-all",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "vocab"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/cpt-all",
  "version" : "1.0.0",
  "name" : "AmaCPTAllCodes",
  "title" : "AMA CPT All Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-05T16:43:13+10:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "All codes in CPT (including metadata, modifiers, etc).",
  "immutable" : true,
  "copyright" : "CPT © Copyright 2023 American Medical Association. All rights reserved. AMA and CPT are registered trademarks of the American Medical Association.",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt"
      }
    ]
  }
}

```
