# Using SNOMED CT with HL7 Standards - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**External Content**](external_content.md)
* [**External Code Systems**](external_code_systems.md)
* **Using SNOMED CT with HL7 Standards**

## Using SNOMED CT with HL7 Standards

This page describes how to use SNOMED CT with HL7 Standards.

### Using SNOMED CT with FHIR R5

#### Summary

| | |
| :--- | :--- |
| Source | SNOMED CT is owned, maintained and distributed by[SNOMED International](http://snomed.org/). SNOMED International is the organization which publishes the International Edition of SNOMED CT. SNOMED International Members may also distribute their own SNOMED CT National Edition, which contains the international release plus local extension content and derivatives. |
| System | The URI[http://snomed.info/sct](http://snomed.info/sct)identifies the SNOMED CT code system. |
| Version | Where a code system version is used, it should be specified as a URI that represents a specific SNOMED CT Edition published on a particular date (e.g. the International Edition or a National Edition, with a version date), following the[SNOMED CT URI Specification](http://snomed.org/uristandard)(see note below). |
| Code | The following SNOMED CT artifacts are valid in the*code*element for the http://snomed.info/sct namespace:* [Concept IDs](https://confluence.ihtsdotools.org/display/DOCGLOSS/concept+identifier); and
* [SNOMED CT Expressions](https://confluence.ihtsdotools.org/display/DOCGLOSS/expression) (using [SNOMED CT Compositional Grammar](https://confluence.ihtsdotools.org/display/DOCSCG/Compositional+Grammar+-+Specification+and+Guide)).
[SNOMED CT Terms](https://confluence.ihtsdotools.org/display/DOCGLOSS/term)and[Description Identifiers](https://confluence.ihtsdotools.org/display/DOCGLOSS/description+identifier)are not valid as codes in FHIR, nor are other alternative identifiers associated with SNOMED CT Concepts.Note: When[SNOMED CT Terms](https://confluence.ihtsdotools.org/display/DOCGLOSS/term)must be exchanged, use the[Description Id Extension.](https://hl7.org/fhir/extension-coding-sctdescid.html) |
| Display | The correct display for a[SNOMED CT concept](https://confluence.ihtsdotools.org/display/DOCGLOSS/Concept)is one of the[terms](https://confluence.ihtsdotools.org/display/DOCGLOSS/term)associated with that concept. The best display is the preferred term in the relevant language or dialect, as specified in the associated language reference set. SNOMED CT synonyms may be case sensitive.SNOMED International does not define terms for expressions. If a SNOMED terminology producer publishes human-readable terms for expressions in an expression repository, this term may be used as the display. Similarly, if a SNOMED terminology producer publishes an official template for generating terms from an expression, a term generated using the template may be used as the display. If no term or description template has been published, the full expression with terms embedded may be used.Note that Display is not intended to contain terms entered by the user that have not been officially published by a SNOMED CT Terminology Producer. |
| Inactive | Inactive codes are identified using the 'inactive' property (see below) |
| Subsumption | SNOMED CT Subsumption testing for concepts is based on the |is a| relationship defined by SNOMED CT |
| Filter Properties | Several filter properties are defined, as described below |

Note: The [SNOMED International glossary](http://snomed.org/gl) explains some of these SNOMED CT specific terms.

#### Copyright and Licenses

The FHIR R5 specification includes content from SNOMED Clinical Terms® (SNOMED CT®) is copyright of the International Health Terminology Standards Development Organisation (IHTSDO) (trading as SNOMED International). Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information access [http://www.snomed.org/snomed-ct/get-snomed-ct](http://www.snomed.org/snomed-ct/get-snomed-ct) or contact SNOMED International via email at [info@snomed.org](mailto:info@snomed.org).

#### Versions

There is no single distribution that contains all defined SNOMED CT codes in all contexts of use. Instead the International Edition contains all concepts shared and agreed to be internationally relevant and each National Release Centre distributes this International Edition plus additional national content (to extend the international set). Other release authorities may also be designated. The [SNOMED CT URI Specification](http://snomed.org/uristandard) describes how to unambiguously reference a particular version of a SNOMED CT edition:

```

  http://snomed.info/sct/[sctid]/version/[YYYYMMDD]

```

where [sctid] is the concept id that identifies the given SNOMED CT edition (based on the identifier of the most dependent module), and "YYYYMMDD" is the date of release. Examples of sctids that identify a specific edition are [listed here](https://confluence.ihtsdotools.org/display/DOCEXTPG/4.4.2+Edition+URI+Examples).

Note that many implementations are in the habit of simply using the date of release in the form YYYYMMDD (e.g. "20140531"), and assuming that the edition is known. However, this is not always safe, so implementations that populate the *version* element SHOULD use the URI form.

Servers SHOULD regard provision of the date only for the version (without an sctid) as an error, and refuse to process the interaction or operation. At minimum the URI SHOULD contain the sctid of the SNOMED CT distribution:

```

http://snomed.info/sct/[sctid]

```

Implementers must note, if no version URI is provided when utilizing SNOMED CT, the Terminology Service may default to the most recent version of the SNOMED CT International Edition available on the service (or the latest available of another edition that may be preferred for the locale). Further, if the date of release is not provided, the Terminology Service may default to the most recent version of the named SNOMED CT distribution (e.g. 32506021000036107 for Australia).

In terms of the CodeSystem resource definitions, this means that SNOMED CT is distributed as a set of overlapping fragments that contain different parts of the entire code system that is SNOMED CT. Terminology servers and users always need to be aware of which fragment(s) are in use at any time, though implementations can sometimes safely assume that a national distribution is the only scope. Note that because of SNOMED CT's large size, there is no expectation that implementers will ever use a CodeSystem resource instead of the SNOMED CT RF2 format as a way to distribute SNOMED CT content.

#### Display Terms for Specific Languages

In the ValueSet resource any number of terms ([designations](https://hl7.org/fhir/valueset.html#designations)) in additional languages and dialects can be specified for a particular concept in a value set definition using the [ValueSet.compose.include.concept.designation](https://hl7.org/fhir/codesystem-definitions.html#CodeSystem.concept.designation) element. The language is specified as a [BCP-47](http://tools.ietf.org/html/bcp47) language code as required by the [designation.language](https://hl7.org/fhir/valueset-definitions.html#ValueSet.compose.include.concept.designation.language) element, with the value taken from the 'languageCode' field of the RF2 Descriptions file ('languageCode' is ISO-639-1, a subset of BCP-47). The [type](https://hl7.org/fhir/valueset-designation-use.html) of the term (e.g., the SNOMED CT code for "Fully specified name", "Synonym" or "Definition") can be specified in [designation.use](https://hl7.org/fhir/valueset-definitions.html#ValueSet.compose.include.concept.designation.use).

[Note that ValueSet.compose.include.concept is only used when the value set is defined extensionally (i.e. as an enumerated list of concepts). For intensionally-defined value sets (i.e. using one or more filters) additional terms could be added using CodeSystem.concept.designation, as noted below.]

The CodeSystem resource can also similarly be used to specify additional terms ([designations](https://hl7.org/fhir/codesystem.html#designations)) for a concept using the [CodeSystem.concept.designation](https://hl7.org/fhir/codesystem-definitions.html#CodeSystem.concept.designation) element (the additional terms may be from a published national or other localized SNOMED CT edition or provided in a [code system supplement](https://hl7.org/fhir/codesystem.html#supplements)). If supported by the terminology server, the additional terms are available to be returned in a [value set expansion](https://hl7.org/fhir/valueset.html#expansion) (controlled by the [$expand](https://hl7.org/fhir/valueset-operation-expand.html#4.8.1.1) operation 'includeDesignations' input parameter).

#### SNOMED CT Expressions

A [SNOMED CT Expression](https://confluence.ihtsdotools.org/display/DOCGLOSS/SNOMED+CT+expression) is a structured combination of one or more clinical concepts, stated using [Compositional Grammar Syntax](https://confluence.ihtsdotools.org/display/DOCSCG). Expressions may optionally contain display terms.

#### RDF

The SNOMED International URI specification uses the namespace http://snomed.info/sct for the code system, and the URI http://snomed.info/id for the individual concepts in the code system. This means that when a SNOMED CT concept is converted from the system::code pair, where the system is http://snomed.info/sct, to the [RDF ontological form](https://hl7.org/fhir//rdf.html), the representation is http://snomed.info/id/[concept-id]. Expressions are represented using the URI pattern http://snomed.info/scg/[expression]. Expressions represented in this way SHALL NOT contain whitespace, terms or comments.

#### SNOMED CT Properties

In addition to the [standard properties](https://hl7.org/fhir/terminology-service.html#standard-props), the following properties are defined for SNOMED CT:

| | | |
| :--- | :--- | :--- |
| **Property Name** | **Data Type** | **Comments** |
| effectiveTime | dateTime | This is the effectiveTime value from the RF2 concepts file (from the snapshot). |
| inactive | boolean | Whether the code is active or not (defaults to false). This is derived from the active column in the Concept file of the RF2 Distribution (by inverting the value). |
| moduleId | code | The SNOMED CT concept id of the module that the concept belongs to. |
| normalForm | string | Generated Necessary Normal Form expression for the provided code or expression, with terms. The normal form expressions are not suitable for use in subsumption testing. |
| normalFormTerse | string | Generated Necessary Normal form expression for the provided code or expression, concept ids only. The normal form expressions are not suitable for use in subsumption testing. |
| semanticTag | code | The phrase inside the last set of brackets of its Fully Specified Name. |
| sufficientlyDefined | boolean | True if the description logic definition of the concept includes sufficient conditions. This is derived from the definitionStatusId value in the Concept file of the RF2 distribution (i.e. If 900000000000073002 |Sufficiently defined concept definition status| then true). |

SNOMED CT relationships, where the relationship type is subsumed by 410662002 |Concept model attribute|, also automatically become properties. Properties that represent SNOMED CT concept model attributes are referred to using their concept id, rather than their human readable term.

For example, the laterality property is represented using the concept id '272741003', rather than the term 'laterality':

| | | |
| :--- | :--- | :--- |
| **Property Name** | **Data Type** | **Comments** |
| 272741003 | code | The value of the laterality attribute in the definition of the given code or expression. The equivalent URI for the laterality property is`[http://snomed.info/id/272741003](http://snomed.info/id/272741003).` |

Note that when a [$lookup](https://hl7.org/fhir/codesystem-operation-lookup.html) operation is performed on a SNOMED CT concept, servers SHALL return the URI for the edition and version being used (see above) in the `version` property. Other properties are at the discretion of the server and the client.

#### SNOMED CT Filters

This section documents the property filters that can be used with the SNOMED CT code system in value set composition statements. For implementer convenience, some of the property filters are documented in terms of the [SNOMED CT Expression Constraint Language](http://snomed.org/ecl), but this does not imply that its use is required.

##### By Subsumption

| | |
| :--- | :--- |
| Description | Select a set of concepts based on subsumption testing |
| Property Name | concept |
| Operations Allowed | is-a |
| Values Allowed | [concept id] |
| Comments | Includes all concept ids that have a transitive is-a relationship with the concept id provided as the value (including the concept itself) |
| Example | [Administration Methods](https://hl7.org/fhir/valueset-administration-method-codes.html) |
| [SCT ECL](http://snomed.org/ecl) | ```<< [concept] (Long syntax: descendantOrSelfOf [concept])``` |

| | |
| :--- | :--- |
| Description | Select a set of concepts based on subsumption testing |
| Property Name | concept |
| Operations Allowed | descendant-of |
| Values Allowed | [concept id] |
| Comments | Includes all concept ids that have a transitive is-a relationship with the concept id provided as the value (excluding the concept itself) |
| [SCT ECL](http://snomed.org/ecl) | ```< [concept] (Long syntax: descendantOf [concept])``` |

##### By Reference Set

| | |
| :--- | :--- |
| Description | Select a set of concepts based on their membership of a SNOMED CT reference set |
| Property Name | concept |
| Operations Allowed | in |
| Values Allowed | [concept id] |
| Comments | Includes all concept ids that are active members of the reference set identified by the concept id provided as the value |
| [SCT ECL](http://snomed.org/ecl) | ```^ [concept] (Long syntax: memberOf [concept])``` |

##### By SNOMED Expression Constraint

| | |
| :--- | :--- |
| Description | Select a set of concepts based on a formal expression constraint |
| Property Name | constraint |
| Operations Allowed | = |
| Values Allowed | [expression constraint] |
| Comments | The result of the filter is the result of executing the given[SNOMED CT Expression Constraint](http://snomed.org/ecl).Example:```"compose": { "include": [ { "system": "http://snomed.info/sct", "filter": [ { "property": "constraint", "op": "=", "value": "<< 30506011000036107 |Australian product|: 700000101000036108 |hasTP| = 17311000168105 |Panadol|" } ] } ] }``` |

##### By whether post-coordination is allowed

| | |
| :--- | :--- |
| Description | Specify whether post-coordination is allowed or not |
| Property Name | expressions |
| Operations Allowed | = |
| Values Allowed | true or false |
| Comments | Expressions, if allowed, are subject to the same rules as precoordinated concepts. [Note: Simple reference sets do not include expressions.] |
| Example | [Administration Methods](https://hl7.org/fhir/valueset-administration-method-codes.html) |
| [SCT ECL](http://snomed.org/ecl) | ```n/a``` |

#### SNOMED CT Implicit Value Sets

Implicit value sets are those whose specification can be predicted based on the grammar of the underlying code system, and the known structure of the URL that identifies them. SNOMED CT has two common sets of implicit value sets defined: By Subsumption, and By Reference Set. These implicit value sets do not use complex queries. Implicit value sets can also be defined using an expression constraint. The implicit value set capability allows a single URL to serve as a value set definition, and can serve as the basis for the [$expand](https://hl7.org/fhir/valueset-operation-expand.html) operation and for other value set references.

If any value set resources exist with an identifier that conforms to the URL patterns specified below, the content of the resource must conform to the template provided. Profiles and other value set references can reference these value sets directly (by reference as a URI, rather than by a literal value set reference).

A SNOMED CT implicit value set URL has two parts:

* The base URL is either [http://snomed.info/sct](http://snomed.info/sct), or the URI for the edition version, in the format specified by SNOMED International in the [SNOMED CT URI Specification](http://snomed.org/uristandard)
* A query portion that specifies the scope of the content

The URL [http://snomed.info/sct](http://snomed.info/sct) should be understood to mean an unspecified edition/version. This defines an incomplete value set whose actual membership will depend on the edition used when it is expanded. If no version or edition is specified, the terminology service SHALL use the latest version available for its default edition (or the International Edition, if no other edition is the default).

For the second part of the URL (the query part), the 5 possible values are:

* ?fhir_vs - all concept ids in the edition/version. If the base URI is [http://snomed.info/sct](http://snomed.info/sct), this means all possible SNOMED CT concepts
* ?fhir_vs=isa/[sctid] - all concept ids that are subsumed by the specified concept.
* ?fhir_vs=refset - all concept ids that correspond to reference sets that are explicitly defined in the specified SNOMED CT edition
* ?fhir_vs=refset/[sctid] - all concept ids in the specified reference set
* ?fhir_vs=ecl/[ecl] - all concept ids that match the supplied (URI-encoded) expression constraint

A value set with a URL that follows the pattern "[edition/version]?fhir_vs=isa/[sctid]" follows this template:

```

<ValueSet xmlns="http://hl7.org/fhir">
  <text>
    <status value="generated"/>
    <div xmlns="http://www.w3.org/1999/xhtml">
     [Some HTML that describes this value set as all concepts subsumed by sctid]
    </div>
  </text>
  <url value="[edition/version]?fhir_vs=isa/[sctid]"/>
  <version value="[edition/version]"/>
  <name value="SNOMED CT Concept [sctid] and descendants"/>
  <description value="All SNOMED CT concepts for [sctid or preferred description]"/>
  <copyright value="This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement"/>
  <status value="active"/>
  <compose>
    <include>
      <system value="http://snomed.info/sct"/>
      <filter>
        <property value="concept"/>
        <op value="is-a"/>
        <value value="[sctid]"/>
      </filter>
    </include>
  </compose>
</ValueSet>

```

The value set with a url that follows the pattern "[edition/version]?fhir_vs=refset" follows this template:

```

<ValueSet xmlns="http://hl7.org/fhir">
  <text>
    <status value="generated"/>
    <div xmlns="http://www.w3.org/1999/xhtml">
     [Some HTML that describes this value set as all concepts with associated reference sets]
    </div>
  </text>
  <url value="[edition/version]?fhir_vs=refset"/>
  <version value="[edition/version]"/>
  <name value="SNOMED CT Reference Sets"/>
  <description value="All SNOMED CT concepts associated with a reference set"/>
  <copyright value="This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement"/>
  <status value="active"/>
  <compose>
    <include>
      <system value="http://snomed.info/sct"/>
      <!-- repeat: one concept element with a code for each concept that has an associated reference set -->
      <concept>
        <code value="[sctid]"/>
      </concept>
      <!-- end repeat -->
    </include>
  </compose>
</ValueSet>

```

For each concept that is associated with a reference set, there will be one 'concept' element with a contained 'code' element that contains the sctid.

A value set with a url that follows the pattern "[edition/version]?fhir_vs=refset/[sctid]" follows this template:

```

<ValueSet xmlns="http://hl7.org/fhir">
  <text>
    <status value="generated"/>
    <div xmlns="http://www.w3.org/1999/xhtml">
     [Some HTML that describes this value set as all concepts in the reference set identified by sctid]
    </div>
  </text>
  <url value="[edition/version]?fhir_vs=refset/[sctid]"/>
  <version value="[edition/version]"/>
  <name value="SNOMED CT Reference Set [sctid]"/>
  <description value="All SNOMED CT concepts in the reference set [sctid or preferred description]"/>
  <copyright value="This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement"/>
  <status value="active"/>
  <compose>
    <include>
      <system value="http://snomed.info/sct"/>
      <filter>
        <property value="concept"/>
        <op value="in"/>
        <value value="[sctid]"/>
      </filter>
    </include>
  </compose>
</ValueSet>

```

A value set with a url that follows the pattern "[edition/version]?fhir_vs=ecl/[ecl]" follows this template:

```

<ValueSet xmlns="http://hl7.org/fhir">
  <text>
    <status value="generated"/>
    <div xmlns="http://www.w3.org/1999/xhtml">
     [Some HTML that describes this value set as all concepts that match the expression constraint ecl]
    </div>
  </text>
  <url value="[edition/version]?fhir_vs=ecl/[ecl]"/>
  <version value="[edition/version]"/>
  <name value="SNOMED CT Concepts matching [ecl]"/>
  <description value="All SNOMED CT concepts that match the expression constraint [ecl]"/>
  <copyright value="This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement"/>
  <status value="active"/>
  <compose>
    <include>
      <system value="http://snomed.info/sct"/>
      <filter>
        <property value="constraint"/>
        <op value="="/>
        <value value="[ecl]"/>
      </filter>
    </include>
  </compose>
</ValueSet>

```

#### SNOMED CT Implicit Concept Maps

Implicit concept maps are those whose specification can be predicted based on the grammar and/or content of the underlying code system, and the known structure of the URL that identifies them. This allows a single URL to serve as a concept map definition that defines a mapping between two sets of concepts, and which can serve as the basis for the [$translate](https://hl7.org/fhir/conceptmap-operation-translate.html) operation. SNOMED CT has two common sets of implicit concept maps defined:

* Association Reference Sets
* Simple Map Reference Sets

[Association Reference Sets](https://confluence.ihtsdotools.org/display/DOCRELFMT/5.2.5+Association+Reference+Set) are part of the core SNOMED CT distribution. The following standard Association Reference sets can be used for implicit concept maps:

* **Name**: POSSIBLY EQUIVALENT TO
  * **Concept Id**: 900000000000523009
  * **Relationship**: inexact
* **Name**: REPLACED BY
  * **Concept Id**: 900000000000526001
  * **Relationship**: equivalent
* **Name**: SAME AS
  * **Concept Id**: 900000000000527005
  * **Relationship**: equal
* **Name**: ALTERNATIVE
  * **Concept Id**: 900000000000530003
  * **Relationship**: inexact

[Simple Map Reference Sets](https://confluence.ihtsdotools.org/display/DOCRELFMT/5.2.5+Association+Reference+Set) (reference sets which are descendants of 900000000000496009 "Simple map") also define an implicit concept map.

If any ConceptMap resources exist with an identifier that conforms to the URL pattern specified below, the content of the resource must conform to the template provided. Canonical references to ConceptMap resource instances are made using their URI.

A SNOMED CT implicit concept map URL has two parts:

* The base URL is either [http://snomed.info/sct](http://snomed.info/sct), or the URI for the edition version, in the format specified by SNOMED International in the [SNOMED CT URI Specification](http://snomed.org/uristandard)
* A query portion that specifies the scope of the content

The URL [http://snomed.info/sct](http://snomed.info/sct) should be understood to mean an unspecified edition/version. This defines an incomplete concept map whose actual membership will depend on the edition being used. If no version or edition is specified, the terminology service SHALL use the latest version available for its default edition (or the International Edition, if no other edition is the default).

For the second part of the URL (the query part), there is only one possible value:

* ?fhir_cm=[sctid] - where [sctid] is a value from the table above

A concept map with a URL that follows the pattern "[edition/version]?fhir_cm=[sctid]" follows this template, where [name], [sctid] and [relationship] are taken from the table above:

```

<ConceptMap xmlns="http://hl7.org/fhir">
  <text>
    <status value="generated"/>
    <div xmlns="http://www.w3.org/1999/xhtml">
     [Some HTML that describes this concept map]
    </div>
  </text>
  <url value="[edition/version]?fhir_cm=[sctid]"/>
  <version value="[edition/version]"/>
  <name value="SNOMED CT [name] Concept Map"/>
  <description value="The concept map implicitly defined by the [name] Association Reference Set"/>
  <copyright value="This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement"/>
  <status value="active"/>

  <sourceUri value="[edition/version]?fhir_vs"/>
  <targetUri value="[edition/version]?fhir_vs"/>
  <group>  <!-- 0..* Same source and target systems -->
    <source value="http://snomed.info/sct"/>
    <target value="http://snomed.info/sct"/>

    <!-- a mapping for each member of the reference set -->
    <element>
      <code value="[member]"/>
      <target>
        <code value="[reference set value]"/>
        <relationship value="[relationship]"/>
      </target>
    </element>
  </group>
</ConceptMap>

```

