# Active Ingredient Group Number - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Active Ingredient Group Number**

## NamingSystem: Active Ingredient Group Number 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hc-aign | *Version*:3.0.0 | |
| Active as of 2021-03-22 | *Responsible:*Health Canada | *Computable Name*:HcAIGN |

 
The AIG number is a 10 digit number that identifies products that have the same active ingredient(s) and ingredient strength(s). The AIG is comprised of three portions: 
* the first portion (2 digits) identifies the number of active ingredients
* the second portion(5 digits) identifies the unique groups of active ingredients(s);
* the last portion (3 digits) identifies the active ingredient group strength. The strength group has a tolerance of -2% to +10%.
 
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-hc-aign |
| Version | 3.0.0 |
| Name | HcAIGN |
| Title | Active Ingredient Group Number |
| Status | active |
| Definition | The AIG number is a 10 digit number that identifies products that have the same active ingredient(s) and ingredient strength(s). The AIG is comprised of three portions:* the first portion (2 digits) identifies the number of active ingredients
* the second portion(5 digits) identifies the unique groups of active ingredients(s);
* the last portion (3 digits) identifies the active ingredient group strength. The strength group has a tolerance of -2% to +10%.
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html |
| Publisher | Health Canada |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1106
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-hc-aign
  * **Preferred**: true
  * **Period**: 2021-03-22 --> (ongoing)
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-4
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hc-aign",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hc-aign",
  "version" : "3.0.0",
  "name" : "HcAIGN",
  "title" : "Active Ingredient Group Number",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-22T00:00:00-04:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada"
    }
  ],
  "responsible" : "HL7 Canada",
  "description" : "The AIG number is a 10 digit number that identifies products that have the same active ingredient(s) and ingredient strength(s). The AIG is comprised of three portions: \r\n\r\n *  the first portion (2 digits) identifies the number of active ingredients\r\n *  the second portion(5 digits) identifies the unique groups of active ingredients(s);\r\n *  the last portion (3 digits) identifies the active ingredient group strength. The strength group has a tolerance of -2% to +10%.\r\n \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1106",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-hc-aign",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-03-22"
      }
    },
    {
      "type" : "uri",
      "value" : "http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-4",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
