# Canadian Classification of Health Interventions - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Canadian Classification of Health Interventions**

## NamingSystem: Canadian Classification of Health Interventions 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-cci | *Version*:2.0.1 | |
| Active as of 2019-03-20 | *Responsible:*Canadian Institute for Health Information | *Computable Name*:CCI |

 
CCI (Canadian Classification of Health Interventions) was developed by CIHI to accompany ICD-10-CA. It was designed to be service-provider and service-setting neutral and can be used comprehensively throughout Canada’s health systems. CCI classifies a broad range of interventions including therapeutic and diagnostic interventions and other health care interventions, such as assistance with activities of daily living, environmental assessments and counselling. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-cci |
| Version | 2.0.1 |
| Name | CCI |
| Title | Canadian Classification of Health Interventions |
| Status | active |
| Definition | CCI (Canadian Classification of Health Interventions) was developed by CIHI to accompany ICD-10-CA. It was designed to be service-provider and service-setting neutral and can be used comprehensively throughout Canada’s health systems. CCI classifies a broad range of interventions including therapeutic and diagnostic interventions and other health care interventions, such as assistance with activities of daily living, environmental assessments and counselling. |
| Publisher | Canadian Institute for Health Information |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.95
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://cihi.ca/fhir/CodeSystem/cihi-cci
  * **Preferred**: true
  * **Period**: 2020-09-24 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-cci",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-cci",
  "version" : "2.0.1",
  "name" : "CCI",
  "title" : "Canadian Classification of Health Interventions",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canadian Institute for Health Information",
  "contact" : [
    {
      "name" : "CIHI (Canadian Institute for Health Information)"
    }
  ],
  "responsible" : "Canadian Institute for Health Information",
  "description" : "CCI  (Canadian Classification of Health Interventions) was developed by CIHI to accompany ICD-10-CA. It was designed to be service-provider and service-setting neutral and can be used comprehensively throughout Canada’s health systems. CCI classifies a broad range of interventions including therapeutic and diagnostic interventions and other health care interventions, such as assistance with activities of daily living, environmental assessments and counselling.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.95",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://cihi.ca/fhir/CodeSystem/cihi-cci",
      "preferred" : true,
      "period" : {
        "start" : "2020-09-24"
      }
    }
  ]
}

```
